/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.contentassist;

import com.google.inject.Inject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalCreator;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalPriorities;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public abstract class AbstractIdeTemplateProposalProvider {
    @Inject
    private IdeContentProposalCreator proposalCreator;
    @Inject
    private IdeContentProposalPriorities proposalPriorities;

    protected Variable variable(String name) {
        return new Variable(name);
    }

    protected Cursor cursor() {
        return new Cursor();
    }

    protected void acceptProposal(String name, String description, StringConcatenationClient template, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        this.acceptProposal(name, description, template, context, acceptor, true);
    }

    protected void acceptProposal(String name, String description, StringConcatenationClient template, ContentAssistContext context, IIdeContentProposalAcceptor acceptor, boolean adaptIndentation) {
        ContentAssistEntry entry = this.createProposal(template, context, adaptIndentation);
        if (this.canAcceptProposal(entry, context)) {
            entry.setLabel(name);
            entry.setDescription(description);
            acceptor.accept(entry, this.proposalPriorities.getDefaultPriority(entry));
        }
    }

    protected boolean canAcceptProposal(ContentAssistEntry entry, ContentAssistContext context) {
        return this.proposalCreator.isValidProposal(entry.getProposal(), entry.getPrefix(), context);
    }

    protected ContentAssistEntry createProposal(StringConcatenationClient template, ContentAssistContext context, boolean adaptIndentation) {
        ContentAssistEntry entry = new ContentAssistEntry();
        entry.setPrefix(context.getPrefix());
        TemplateStringConcatenation stringConcat = new TemplateStringConcatenation(context, entry, this.getLineDelimiter());
        String indentation = null;
        if (adaptIndentation) {
            indentation = this.getIndentation(context);
        }
        if (indentation == null) {
            stringConcat.append(template);
        } else {
            stringConcat.append(template, indentation);
        }
        entry.setProposal(stringConcat.toString());
        return entry;
    }

    protected String getLineDelimiter() {
        return StringConcatenation.DEFAULT_LINE_DELIMITER;
    }

    protected String getIndentation(ContentAssistContext context) {
        String text = null;
        if (context.getRootNode() != null) {
            text = context.getRootNode().getText();
        }
        if (text != null && text.length() >= context.getOffset()) {
            int lineStart;
            int indentEnd = lineStart = context.getReplaceRegion().getOffset();
            while (lineStart > 0 && text.charAt(lineStart - 1) != '\n') {
                if (Character.isWhitespace(text.charAt(--lineStart))) continue;
                indentEnd = lineStart;
            }
            return text.substring(lineStart, indentEnd);
        }
        return null;
    }

    protected static class Cursor {
        protected Cursor() {
        }
    }

    private static class TemplateStringConcatenation
    extends StringConcatenation {
        private final ContentAssistContext context;
        private final ContentAssistEntry entry;

        public TemplateStringConcatenation(ContentAssistContext context, ContentAssistEntry entry, String lineDelimiter) {
            super(lineDelimiter);
            this.context = context;
            this.entry = entry;
        }

        protected String getStringRepresentation(Object object) {
            if (object instanceof Variable) {
                String varName = ((Variable)object).name;
                int offset = this.context.getReplaceRegion().getOffset() + this.getCurrentOffset();
                this.entry.getEditPositions().add(new TextRegion(offset, varName.length()));
                return varName;
            }
            if (object instanceof Cursor) {
                this.entry.setEscapePosition(this.context.getReplaceRegion().getOffset() + this.getCurrentOffset());
                return null;
            }
            return object.toString();
        }

        protected int getCurrentOffset() {
            int result = 0;
            for (String segment : this.getContent()) {
                result += segment.length();
            }
            return result;
        }

        public void newLineIfNotEmpty() {
            this.newLine();
        }
    }

    protected static class Variable {
        private final String name;

        public Variable(String name) {
            this.name = name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Variable other = (Variable)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("name", (Object)this.name);
            return b.toString();
        }

        public String getName() {
            return this.name;
        }
    }
}

