/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.lib.annotations;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import java.util.Arrays;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.annotations.EqualsHashCode;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@Beta
public class EqualsHashCodeProcessor
extends AbstractClassProcessor {
    public void doTransform(MutableClassDeclaration it, final @Extension TransformationContext context) {
        boolean _tripleNotEquals;
        AnnotationReference _findAnnotation = it.findAnnotation(context.findTypeGlobally(Data.class));
        boolean bl = _tripleNotEquals = _findAnnotation != null;
        if (_tripleNotEquals) {
            return;
        }
        Util util = new Util(context);
        boolean _hasEquals = util.hasEquals((ClassDeclaration)it);
        if (_hasEquals) {
            AnnotationReference annotation = it.findAnnotation(context.findTypeGlobally(EqualsHashCode.class));
            context.addWarning((Element)annotation, "equals is already defined, this annotation has no effect");
        } else {
            boolean _hasHashCode = util.hasHashCode((ClassDeclaration)it);
            if (_hasHashCode) {
                context.addWarning((Element)it, "hashCode is already defined, this annotation has no effect");
            } else {
                Functions.Function1<MutableFieldDeclaration, Boolean> _function = new Functions.Function1<MutableFieldDeclaration, Boolean>(){

                    public Boolean apply(MutableFieldDeclaration it) {
                        return !it.isStatic() && !it.isTransient() && context.isThePrimaryGeneratedJavaElement((Element)it);
                    }
                };
                Iterable fields = IterableExtensions.filter((Iterable)it.getDeclaredFields(), (Functions.Function1)_function);
                util.addEquals(it, fields, util.hasSuperEquals((ClassDeclaration)it));
                util.addHashCode(it, fields, util.hasSuperHashCode((ClassDeclaration)it));
            }
        }
    }

    @Beta
    public static class Util {
        @Extension
        private TransformationContext context;

        public Util(TransformationContext context) {
            this.context = context;
        }

        public boolean hasHashCode(ClassDeclaration it) {
            MethodDeclaration _findDeclaredMethod = it.findDeclaredMethod("hashCode", new TypeReference[0]);
            return _findDeclaredMethod != null;
        }

        public boolean hasEquals(ClassDeclaration it) {
            Functions.Function1<MethodDeclaration, Boolean> _function = new Functions.Function1<MethodDeclaration, Boolean>(){

                public Boolean apply(MethodDeclaration it) {
                    return Objects.equal((Object)it.getSimpleName(), (Object)"equals") && IterableExtensions.size((Iterable)it.getParameters()) == 1 && Objects.equal((Object)((ParameterDeclaration)IterableExtensions.head((Iterable)it.getParameters())).getType(), (Object)Util.this.context.getObject());
                }
            };
            return IterableExtensions.exists((Iterable)it.getDeclaredMethods(), (Functions.Function1)_function);
        }

        public boolean hasSuperEquals(ClassDeclaration cls) {
            boolean _xblockexpression = false;
            Type _type = cls.getExtendedClass().getType();
            ClassDeclaration superClass = (ClassDeclaration)_type;
            boolean _xifexpression = false;
            boolean _equals = this.context.newTypeReference((Type)superClass, new TypeReference[0]).equals((Object)this.context.getObject());
            if (_equals) {
                _xifexpression = false;
            } else {
                boolean _xifexpression_1 = false;
                boolean _hasEquals = this.hasEquals(superClass);
                _xifexpression_1 = _hasEquals ? true : this.hasSuperEquals(superClass);
                _xifexpression = _xifexpression_1;
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        public boolean hasSuperHashCode(ClassDeclaration cls) {
            boolean _xblockexpression = false;
            Type _type = cls.getExtendedClass().getType();
            ClassDeclaration superClass = (ClassDeclaration)_type;
            boolean _xifexpression = false;
            boolean _equals = this.context.newTypeReference((Type)superClass, new TypeReference[0]).equals((Object)this.context.getObject());
            if (_equals) {
                _xifexpression = false;
            } else {
                boolean _xifexpression_1 = false;
                boolean _hasHashCode = this.hasHashCode(superClass);
                _xifexpression_1 = _hasHashCode ? true : this.hasSuperHashCode(superClass);
                _xifexpression = _xifexpression_1;
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        public void addEquals(final MutableClassDeclaration cls, final Iterable<? extends FieldDeclaration> includedFields, final boolean includeSuper) {
            Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    Util.this.context.setPrimarySourceElement((MutableElement)it, Util.this.context.getPrimarySourceElement((Element)cls));
                    it.setReturnType(Util.this.context.getPrimitiveBoolean());
                    it.addAnnotation(Util.this.context.newAnnotationReference(Override.class));
                    it.addAnnotation(Util.this.context.newAnnotationReference(Pure.class));
                    it.addParameter("obj", Util.this.context.getObject());
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            int _size;
                            boolean _greaterThan;
                            _builder.append((Object)"if (this == obj)");
                            _builder.newLine();
                            _builder.append((Object)"  ");
                            _builder.append((Object)"return true;");
                            _builder.newLine();
                            _builder.append((Object)"if (obj == null)");
                            _builder.newLine();
                            _builder.append((Object)"  ");
                            _builder.append((Object)"return false;");
                            _builder.newLine();
                            _builder.append((Object)"if (getClass() != obj.getClass())");
                            _builder.newLine();
                            _builder.append((Object)"  ");
                            _builder.append((Object)"return false;");
                            _builder.newLine();
                            if (includeSuper) {
                                _builder.append((Object)"if (!super.equals(obj))");
                                _builder.newLine();
                                _builder.append((Object)"  ");
                                _builder.append((Object)"return false;");
                                _builder.newLine();
                            }
                            boolean bl = _greaterThan = (_size = IterableExtensions.size((Iterable)includedFields)) > 0;
                            if (_greaterThan) {
                                TypeReference _newWildCardSelfTypeReference = Util.this.newWildCardSelfTypeReference((ClassDeclaration)cls);
                                _builder.append((Object)_newWildCardSelfTypeReference);
                                _builder.append((Object)" other = (");
                                TypeReference _newWildCardSelfTypeReference_1 = Util.this.newWildCardSelfTypeReference((ClassDeclaration)cls);
                                _builder.append((Object)_newWildCardSelfTypeReference_1);
                                _builder.append((Object)") obj;");
                                _builder.newLineIfNotEmpty();
                            }
                            for (FieldDeclaration field : includedFields) {
                                StringConcatenationClient _contributeToEquals = Util.this.contributeToEquals(field);
                                _builder.append((Object)_contributeToEquals);
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append((Object)"return true;");
                            _builder.newLine();
                        }
                    };
                    it.setBody(_client);
                }
            };
            cls.addMethod("equals", (Procedures.Procedure1)_function);
        }

        private TypeReference newWildCardSelfTypeReference(ClassDeclaration cls) {
            Functions.Function1<TypeParameterDeclaration, TypeReference> _function = new Functions.Function1<TypeParameterDeclaration, TypeReference>(){

                public TypeReference apply(TypeParameterDeclaration it) {
                    return Util.this.context.newWildcardTypeReference(Util.this.context.getObject());
                }
            };
            return this.context.newTypeReference((Type)cls, (TypeReference[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)cls.getTypeParameters(), (Functions.Function1)_function), TypeReference.class));
        }

        public StringConcatenationClient contributeToEquals(final FieldDeclaration it) {
            String _name_2;
            StringConcatenationClient _switchResult = null;
            String _name = this.orObject(it.getType()).getName();
            boolean _matched = false;
            String _name_1 = Double.TYPE.getName();
            if (Objects.equal((Object)_name, (Object)_name_1)) {
                StringConcatenationClient _client;
                _matched = true;
                _switchResult = _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (");
                        _builder.append(Double.class);
                        _builder.append((Object)".doubleToLongBits(other.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)") != ");
                        _builder.append(Double.class);
                        _builder.append((Object)".doubleToLongBits(this.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append((Object)_simpleName_1);
                        _builder.append((Object)"))");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"  ");
                        _builder.append((Object)"return false; ");
                        _builder.newLine();
                    }
                };
            }
            if (!_matched && Objects.equal((Object)_name, (Object)(_name_2 = Float.TYPE.getName()))) {
                StringConcatenationClient _client_1;
                _matched = true;
                _switchResult = _client_1 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (");
                        _builder.append(Float.class);
                        _builder.append((Object)".floatToIntBits(other.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)") != ");
                        _builder.append(Float.class);
                        _builder.append((Object)".floatToIntBits(this.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append((Object)_simpleName_1);
                        _builder.append((Object)"))");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"  ");
                        _builder.append((Object)"return false; ");
                        _builder.newLine();
                    }
                };
            }
            if (!_matched) {
                String _name_8;
                String _name_7;
                String _name_6;
                String _name_5;
                String _name_4;
                String _name_3 = Boolean.TYPE.getName();
                if (Objects.equal((Object)_name, (Object)_name_3)) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_4 = Integer.TYPE.getName()))) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_5 = Character.TYPE.getName()))) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_6 = Byte.TYPE.getName()))) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_7 = Short.TYPE.getName()))) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_8 = Long.TYPE.getName()))) {
                    _matched = true;
                }
                if (_matched) {
                    StringConcatenationClient _client_2;
                    _switchResult = _client_2 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"if (other.");
                            String _simpleName = it.getSimpleName();
                            _builder.append((Object)_simpleName);
                            _builder.append((Object)" != this.");
                            String _simpleName_1 = it.getSimpleName();
                            _builder.append((Object)_simpleName_1);
                            _builder.append((Object)")");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"  ");
                            _builder.append((Object)"return false;");
                            _builder.newLine();
                        }
                    };
                }
            }
            if (!_matched) {
                StringConcatenationClient _client_3;
                _switchResult = _client_3 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)" == null) {");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"  ");
                        _builder.append((Object)"if (other.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append((Object)_simpleName_1, "  ");
                        _builder.append((Object)" != null)");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"    ");
                        _builder.append((Object)"return false;");
                        _builder.newLine();
                        _builder.append((Object)"} else if (!");
                        StringConcatenationClient _deepEquals = Util.this.deepEquals(it);
                        _builder.append((Object)_deepEquals);
                        _builder.append((Object)")");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"  ");
                        _builder.append((Object)"return false;");
                        _builder.newLine();
                    }
                };
            }
            return _switchResult;
        }

        public StringConcatenationClient deepEquals(final FieldDeclaration it) {
            StringConcatenationClient _xifexpression = null;
            boolean _isArray = it.getType().isArray();
            if (_isArray) {
                StringConcatenationClient _client_1;
                StringConcatenationClient _client;
                StringConcatenationClient _xifexpression_1 = null;
                boolean _isPrimitive = it.getType().getArrayComponentType().isPrimitive();
                _xifexpression_1 = _isPrimitive ? (_client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append(Arrays.class);
                        _builder.append((Object)".equals(this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)", other.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append((Object)_simpleName_1);
                        _builder.append((Object)")");
                    }
                }) : (_client_1 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append(Arrays.class);
                        _builder.append((Object)".deepEquals(this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)", other.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append((Object)_simpleName_1);
                        _builder.append((Object)")");
                    }
                });
                _xifexpression = _xifexpression_1;
            } else {
                StringConcatenationClient _client_2;
                _xifexpression = _client_2 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)".equals(other.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append((Object)_simpleName_1);
                        _builder.append((Object)")");
                    }
                };
            }
            return _xifexpression;
        }

        public void addHashCode(final MutableClassDeclaration cls, final Iterable<? extends FieldDeclaration> includedFields, final boolean includeSuper) {
            Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    Util.this.context.setPrimarySourceElement((MutableElement)it, Util.this.context.getPrimarySourceElement((Element)cls));
                    it.setReturnType(Util.this.context.getPrimitiveInt());
                    it.addAnnotation(Util.this.context.newAnnotationReference(Override.class));
                    it.addAnnotation(Util.this.context.newAnnotationReference(Pure.class));
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            boolean _greaterThan;
                            int _size = IterableExtensions.size((Iterable)includedFields);
                            boolean bl = _greaterThan = _size > 0;
                            if (_greaterThan) {
                                _builder.append((Object)"final int prime = 31;");
                                _builder.newLine();
                            }
                            _builder.append((Object)"int result = ");
                            if (includeSuper) {
                                _builder.append((Object)"super.hashCode()");
                            } else {
                                _builder.append((Object)"1");
                            }
                            _builder.append((Object)";");
                            _builder.newLineIfNotEmpty();
                            for (FieldDeclaration field : includedFields) {
                                StringConcatenationClient _contributeToHashCode = Util.this.contributeToHashCode(field);
                                _builder.append((Object)_contributeToHashCode);
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append((Object)"return result;");
                            _builder.newLine();
                        }
                    };
                    it.setBody(_client);
                }
            };
            cls.addMethod("hashCode", (Procedures.Procedure1)_function);
        }

        public StringConcatenationClient contributeToHashCode(final FieldDeclaration it) {
            String _name_8;
            String _name_3;
            String _name_2;
            StringConcatenationClient _switchResult = null;
            String _name = this.orObject(it.getType()).getName();
            boolean _matched = false;
            String _name_1 = Double.TYPE.getName();
            if (Objects.equal((Object)_name, (Object)_name_1)) {
                StringConcatenationClient _client;
                _matched = true;
                _switchResult = _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"result = prime * result + (int) (");
                        _builder.append(Double.class);
                        _builder.append((Object)".doubleToLongBits(this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)") ^ (");
                        _builder.append(Double.class);
                        _builder.append((Object)".doubleToLongBits(this.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append((Object)_simpleName_1);
                        _builder.append((Object)") >>> 32));");
                    }
                };
            }
            if (!_matched && Objects.equal((Object)_name, (Object)(_name_2 = Float.TYPE.getName()))) {
                StringConcatenationClient _client_1;
                _matched = true;
                _switchResult = _client_1 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"result = prime * result + ");
                        _builder.append(Float.class);
                        _builder.append((Object)".floatToIntBits(this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)");");
                    }
                };
            }
            if (!_matched && Objects.equal((Object)_name, (Object)(_name_3 = Boolean.TYPE.getName()))) {
                StringConcatenationClient _client_2;
                _matched = true;
                _switchResult = _client_2 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"result = prime * result + (this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)" ? 1231 : 1237);");
                    }
                };
            }
            if (!_matched) {
                String _name_7;
                String _name_6;
                String _name_5;
                String _name_4 = Integer.TYPE.getName();
                if (Objects.equal((Object)_name, (Object)_name_4)) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_5 = Character.TYPE.getName()))) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_6 = Byte.TYPE.getName()))) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_7 = Short.TYPE.getName()))) {
                    _matched = true;
                }
                if (_matched) {
                    StringConcatenationClient _client_3;
                    _switchResult = _client_3 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"result = prime * result + this.");
                            String _simpleName = it.getSimpleName();
                            _builder.append((Object)_simpleName);
                            _builder.append((Object)";");
                        }
                    };
                }
            }
            if (!_matched && Objects.equal((Object)_name, (Object)(_name_8 = Long.TYPE.getName()))) {
                StringConcatenationClient _client_4;
                _matched = true;
                _switchResult = _client_4 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"result = prime * result + (int) (this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)" ^ (this.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append((Object)_simpleName_1);
                        _builder.append((Object)" >>> 32));");
                    }
                };
            }
            if (!_matched) {
                StringConcatenationClient _client_5;
                _switchResult = _client_5 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"result = prime * result + ((this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)"== null) ? 0 : ");
                        StringConcatenationClient _deepHashCode = Util.this.deepHashCode(it);
                        _builder.append((Object)_deepHashCode);
                        _builder.append((Object)");");
                    }
                };
            }
            return _switchResult;
        }

        public StringConcatenationClient deepHashCode(final FieldDeclaration it) {
            StringConcatenationClient _xblockexpression = null;
            TypeReference type = this.orObject(it.getType());
            StringConcatenationClient _xifexpression = null;
            boolean _isArray = type.isArray();
            if (_isArray) {
                StringConcatenationClient _client_1;
                StringConcatenationClient _client;
                StringConcatenationClient _xifexpression_1 = null;
                boolean _isPrimitive = type.getArrayComponentType().isPrimitive();
                _xifexpression_1 = _isPrimitive ? (_client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append(Arrays.class);
                        _builder.append((Object)".hashCode(this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)")");
                    }
                }) : (_client_1 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append(Arrays.class);
                        _builder.append((Object)".deepHashCode(this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)")");
                    }
                });
                _xifexpression = _xifexpression_1;
            } else {
                StringConcatenationClient _client_2;
                _xifexpression = _client_2 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)".hashCode()");
                    }
                };
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        private TypeReference orObject(TypeReference ref) {
            TypeReference _object;
            TypeReference _elvis = null;
            _elvis = ref != null ? ref : (_object = this.context.getObject());
            return _elvis;
        }
    }
}

