/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.maven.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.oomph.base.impl.ModelElementImpl;
import org.eclipse.oomph.maven.Coordinate;
import org.eclipse.oomph.maven.Dependency;
import org.eclipse.oomph.maven.MavenFactory;
import org.eclipse.oomph.maven.MavenPackage;
import org.eclipse.oomph.maven.Parent;
import org.eclipse.oomph.maven.Project;
import org.eclipse.oomph.maven.Property;
import org.eclipse.oomph.maven.PropertyReference;
import org.eclipse.oomph.maven.Realm;
import org.eclipse.oomph.maven.util.POMXMLUtil;
import org.eclipse.oomph.predicates.impl.RepositoryPredicateImpl;
import org.eclipse.oomph.resources.ProjectHandler;
import org.eclipse.oomph.resources.ResourcesFactory;
import org.eclipse.oomph.resources.SourceLocator;
import org.eclipse.oomph.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class RealmImpl
extends ModelElementImpl
implements Realm {
    private static final Set<Path> IGNORED_TARGET_FOLDERS = Set.of(Path.of("target", new String[0]), Path.of("bin", new String[0]));
    protected EList<SourceLocator> sourceLocators;
    protected EList<Project> projects;
    private final Map<Coordinate, Project> projectsByCoordinate = new TreeMap<Coordinate, Project>(Coordinate.COMPARATOR);
    private final Map<Coordinate, Project> projectsByCoordinateIgnoreVersion = new TreeMap<Coordinate, Project>(Coordinate.COMPARATOR_IGNORE_VERSION);

    protected RealmImpl() {
    }

    protected EClass eStaticClass() {
        return MavenPackage.Literals.REALM;
    }

    @Override
    public EList<SourceLocator> getSourceLocators() {
        if (this.sourceLocators == null) {
            this.sourceLocators = new EObjectContainmentEList(SourceLocator.class, (InternalEObject)this, 1);
        }
        return this.sourceLocators;
    }

    @Override
    public EList<Project> getProjects() {
        if (this.projects == null) {
            this.projects = new EObjectContainmentWithInverseEList(Project.class, (InternalEObject)this, 2, 9);
        }
        return this.projects;
    }

    @Override
    public void reconcile() {
        Path location;
        Object sourceLocators = this.getSourceLocators();
        if (sourceLocators.isEmpty()) {
            LinkedHashSet<Path> roots = new LinkedHashSet<Path>();
            IProject[] iProjectArray = EcorePlugin.getWorkspaceRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath projectLocation;
                IProject iProject = iProjectArray[n2];
                location = RepositoryPredicateImpl.getRepositoryLocation((IProject)iProject);
                if ((location == null || location.getParent() == null) && (projectLocation = iProject.getLocation()) != null) {
                    location = projectLocation.toPath();
                }
                if (location != null) {
                    roots.add(location);
                }
                ++n2;
            }
            sourceLocators = new ArrayList();
            for (Path path : roots) {
                SourceLocator sourceLocator = ResourcesFactory.eINSTANCE.createSourceLocator(path.toString());
                sourceLocator.setLocateNestedProjects(true);
                sourceLocator.getProjectFactories().add((Object)ResourcesFactory.eINSTANCE.createMavenProjectFactory());
                sourceLocators.add(sourceLocator);
            }
        } else {
            sourceLocators = EcoreUtil.copyAll(sourceLocators);
            Iterator iterator = sourceLocators.iterator();
            while (iterator.hasNext()) {
                SourceLocator sourceLocator = (SourceLocator)iterator.next();
                sourceLocator.setRootFolder(StringUtil.performStringSubstitution((String)sourceLocator.getRootFolder()));
            }
        }
        EList<Project> projects = this.getProjects();
        projects.clear();
        this.projectsByCoordinate.clear();
        this.projectsByCoordinateIgnoreVersion.clear();
        ArrayList arrayList = new ArrayList();
        Iterator sourceLocator = sourceLocators.iterator();
        while (sourceLocator.hasNext()) {
            SourceLocator sourceLocator2 = (SourceLocator)sourceLocator.next();
            ProjectHandler projectHandler = (project, backendContainer) -> {
                List list2 = arrayList;
                synchronized (list2) {
                    arrayList.add(project);
                }
            };
            MultiStatus status = new MultiStatus("_", 0, "", null);
            sourceLocator2.handleProjects(ECollections.emptyEList(), projectHandler, status, (IProgressMonitor)new NullProgressMonitor());
        }
        ArrayList<Object> reconciledProjects = new ArrayList<Object>();
        for (Object project2 : arrayList) {
            Path pomLocation;
            location = project2.getLocation();
            if (location == null || !Files.isRegularFile(pomLocation = location.toPath().resolve("pom.xml"), new LinkOption[0]) || this.isInProjectTarget(pomLocation)) continue;
            try {
                Document document = POMXMLUtil.parseDocument(pomLocation);
                Project mavenProject = MavenFactory.eINSTANCE.createProject();
                mavenProject.setLocation(pomLocation.toString());
                Element pom = document.getDocumentElement();
                mavenProject.setElement(pom);
                Element parentElement = POMXMLUtil.getElement(pom, POMXMLUtil.xpath("parent"));
                if (parentElement != null) {
                    Parent parent = MavenFactory.eINSTANCE.createParent();
                    parent.setElement(parentElement);
                    mavenProject.setParent(parent);
                }
                if (Boolean.TRUE.booleanValue()) {
                    List<Element> dependencyElements = POMXMLUtil.getElements(pom, POMXMLUtil.xpath("dependencies", "dependency"));
                    EList<Dependency> dependencies = mavenProject.getDependencies();
                    for (Element dependencyElement : dependencyElements) {
                        Dependency dependency = MavenFactory.eINSTANCE.createDependency();
                        dependency.setElement(dependencyElement);
                        dependencies.add((Object)dependency);
                    }
                    List<Element> managedDependencyElements = POMXMLUtil.getElements(pom, POMXMLUtil.xpath("dependencyManagement", "dependencies", "dependency"));
                    EList<Dependency> managedDependencies = mavenProject.getManagedDependencies();
                    for (Element dependencyElement : managedDependencyElements) {
                        Dependency dependency = MavenFactory.eINSTANCE.createDependency();
                        dependency.setElement(dependencyElement);
                        managedDependencies.add((Object)dependency);
                    }
                    List<Element> propertyElements = POMXMLUtil.getElements(pom, POMXMLUtil.xpath("properties", "*"));
                    EList<Property> properties = mavenProject.getProperties();
                    for (Element element : propertyElements) {
                        Property property = MavenFactory.eINSTANCE.createProperty();
                        property.setElement(element);
                        properties.add((Object)property);
                    }
                    properties.add((Object)RealmImpl.createProperty(document, "project.groupId", mavenProject.getGroupId()));
                    properties.add((Object)RealmImpl.createProperty(document, "project.artifactId", mavenProject.getArtifactId()));
                    properties.add((Object)RealmImpl.createProperty(document, "project.version", mavenProject.getVersion()));
                    ECollections.sort(properties, Property.COMPARATOR);
                }
                reconciledProjects.add(mavenProject);
            }
            catch (IOException | SAXException document) {
                // empty catch block
            }
        }
        Collections.sort(reconciledProjects, Coordinate.COMPARATOR);
        projects.addAll(reconciledProjects);
        for (Object project2 : projects) {
            Parent parent = project2.getParent();
            if (parent == null) continue;
            parent.setResolvedProject(this.getProjectIgnoreVersion(parent));
            Document document = project2.getElement().getOwnerDocument();
            EList<Property> properties = project2.getProperties();
            properties.add((Object)RealmImpl.createProperty(document, "project.parent.groupId", project2.getGroupId()));
            properties.add((Object)RealmImpl.createProperty(document, "project.parent.artifactId", project2.getArtifactId()));
            ECollections.sort(properties, Property.COMPARATOR);
        }
        for (Object project2 : projects) {
            Project resolvedProject;
            EList<Dependency> dependencies = project2.getDependencies();
            for (Dependency dependency : dependencies) {
                dependency.getExpandedGroupId();
                dependency.getExpandedVersion();
            }
            ECollections.sort(dependencies, Coordinate.COMPARATOR);
            EList<Dependency> managedDependencies = project2.getManagedDependencies();
            for (Dependency managedDependency : managedDependencies) {
                managedDependency.getExpandedGroupId();
                managedDependency.getExpandedVersion();
            }
            ECollections.sort(managedDependencies, Coordinate.COMPARATOR);
            for (Dependency dependency : dependencies) {
                Dependency managedDependency = project2.getManagedDependency(dependency);
                if (managedDependency == null) continue;
                dependency.setResolvedManagedDependency(managedDependency);
            }
            Parent parent = project2.getParent();
            if (parent != null && (resolvedProject = parent.getResolvedProject()) != null) {
                for (Dependency managedDependency : managedDependencies) {
                    Dependency parentMmanagedDependency = resolvedProject.getManagedDependency(managedDependency);
                    if (managedDependency == null) continue;
                    managedDependency.setResolvedManagedDependency(parentMmanagedDependency);
                }
            }
            ECollections.sort(project2.getIncomingParentReferences(), Coordinate.COMPARATOR);
            ECollections.sort(project2.getIncomingDependencyReferences(), Coordinate.COMPARATOR);
        }
        LinkedHashSet<Property> allProperties = new LinkedHashSet<Property>();
        TreeIterator it = this.eAllContents();
        while (it.hasNext()) {
            EObject eObject = (EObject)it.next();
            if (eObject instanceof Coordinate) {
                Coordinate coordinate = (Coordinate)eObject;
                coordinate.getExpandedGroupId();
                coordinate.getExpandedVersion();
            }
            if (eObject instanceof Property) {
                Property property = (Property)eObject;
                allProperties.add(property);
            }
            if (!(eObject instanceof Dependency)) continue;
            Dependency dependency = (Dependency)eObject;
            dependency.setResolvedProject(this.getProjectIgnoreVersion(dependency));
        }
        LinkedHashSet<Property> allReferencedProperties = new LinkedHashSet<Property>();
        TreeIterator it2 = this.eAllContents();
        while (it2.hasNext()) {
            EObject eObject = (EObject)it2.next();
            if (!(eObject instanceof PropertyReference)) continue;
            PropertyReference propertyReference = (PropertyReference)eObject;
            allReferencedProperties.add(propertyReference.getResolvedProperty());
        }
        if (Boolean.TRUE.booleanValue()) {
            allProperties.removeAll(allReferencedProperties);
            EcoreUtil.deleteAll(allProperties, (boolean)true);
        }
    }

    @Override
    public Project getProject(Coordinate coordinate) {
        EList<Project> projects = this.getProjects();
        if (!projects.isEmpty() && this.projectsByCoordinate.isEmpty()) {
            for (Project project : projects) {
                this.projectsByCoordinate.put(project, project);
            }
        }
        return this.projectsByCoordinate.get(coordinate);
    }

    @Override
    public Project getProjectIgnoreVersion(Coordinate coordinate) {
        if (!this.projects.isEmpty() && this.projectsByCoordinateIgnoreVersion.isEmpty()) {
            for (Project project : this.projects) {
                this.projectsByCoordinateIgnoreVersion.put(project, project);
            }
        }
        return this.projectsByCoordinateIgnoreVersion.get(coordinate);
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getProjects()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getSourceLocators()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getProjects()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getSourceLocators();
            }
            case 2: {
                return this.getProjects();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getSourceLocators().clear();
                this.getSourceLocators().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getProjects().clear();
                this.getProjects().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getSourceLocators().clear();
                return;
            }
            case 2: {
                this.getProjects().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.sourceLocators != null && !this.sourceLocators.isEmpty();
            }
            case 2: {
                return this.projects != null && !this.projects.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                this.reconcile();
                return null;
            }
            case 2: {
                return this.getProject((Coordinate)arguments.get(0));
            }
            case 3: {
                return this.getProjectIgnoreVersion((Coordinate)arguments.get(0));
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    private boolean isInProjectTarget(Path path) {
        Path parent = path.getParent();
        while (parent != null) {
            Path fileName = parent.getFileName();
            if (fileName != null && IGNORED_TARGET_FOLDERS.contains(fileName) && Files.isRegularFile(parent.resolve("../pom.xml"), new LinkOption[0])) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private static Property createProperty(Document document, String key, String value) {
        Element propertyElement = document.createElementNS("", key);
        propertyElement.appendChild(document.createTextNode(value));
        Property property = MavenFactory.eINSTANCE.createProperty();
        property.setElement(propertyElement);
        return property;
    }

    public State getState() {
        return new State(new ArrayList<Project>((Collection<Project>)this.projects), new LinkedHashMap<Coordinate, Project>(this.projectsByCoordinate), new LinkedHashMap<Coordinate, Project>(this.projectsByCoordinateIgnoreVersion));
    }

    public void setState(State state) {
        EList<Project> projects = this.getProjects();
        projects.clear();
        projects.addAll(state.projects);
        this.projectsByCoordinate.clear();
        this.projectsByCoordinate.putAll(state.projectsByCoordinate);
        this.projectsByCoordinateIgnoreVersion.clear();
        this.projectsByCoordinateIgnoreVersion.putAll(state.projectsByCoordinateIgnoreVersion);
    }

    public record State(List<? extends Project> projects, Map<Coordinate, Project> projectsByCoordinate, Map<Coordinate, Project> projectsByCoordinateIgnoreVersion) {
    }
}

