/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.selection;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.egit.ui.internal.RepositoryStateCache;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;

public class SelectionRepositoryStateCache
extends RepositoryStateCache {
    public static final SelectionRepositoryStateCache INSTANCE = new SelectionRepositoryStateCache();
    private final AtomicBoolean stopped = new AtomicBoolean();

    private SelectionRepositoryStateCache() {
    }

    @Override
    public void initialize() {
        IEclipseContext applicationContext = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
        applicationContext.runAndTrack((RunAndTrack)new ContextListener(this.stopped, this::clear));
    }

    @Override
    public void dispose() {
        this.stopped.set(true);
        super.dispose();
    }

    private static class ContextListener
    extends RunAndTrack {
        private AtomicBoolean stopped;
        private final Runnable clearCache;
        private Object lastSelection;
        private Object lastMenuSelection;

        ContextListener(AtomicBoolean stopped, Runnable clearCache) {
            this.stopped = stopped;
            this.clearCache = clearCache;
        }

        public boolean changed(IEclipseContext context) {
            Object menuSelection;
            if (this.stopped.get()) {
                this.clearCache.run();
                return false;
            }
            Object selection = context.get("selection");
            if (selection instanceof ITextSelection) {
                selection = this.getInput(context);
            }
            if ((menuSelection = context.getActive("activeMenuSelection")) instanceof ITextSelection) {
                menuSelection = this.getInput(context);
            }
            if (selection != this.lastSelection || menuSelection != this.lastMenuSelection) {
                this.clearCache.run();
            }
            this.lastSelection = selection;
            this.lastMenuSelection = menuSelection;
            return true;
        }

        private Object getInput(IEclipseContext context) {
            Object[] input = new Object[1];
            this.runExternalCode(() -> {
                IEditorInput e = this.getEditorInput(context);
                objectArray[0] = e != null ? e : StructuredSelection.EMPTY;
            });
            return input[0];
        }

        private IEditorInput getEditorInput(IEclipseContext context) {
            Object nestedEditor;
            Object part = context.get("activePart");
            if (!(part instanceof IEditorPart)) {
                return null;
            }
            Object object = context.get("activeEditorInput");
            Object editor = context.get("activeEditor");
            if (editor instanceof MultiPageEditorPart && (nestedEditor = ((MultiPageEditorPart)editor).getSelectedPage()) instanceof IEditorPart) {
                object = ((IEditorPart)nestedEditor).getEditorInput();
            }
            if (!(object instanceof IEditorInput) && editor instanceof IEditorPart) {
                object = ((IEditorPart)editor).getEditorInput();
            }
            if (object instanceof IEditorInput) {
                return (IEditorInput)object;
            }
            return null;
        }
    }
}

