/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.config;

import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigSchema;
import org.eclipse.rdf4j.repository.config.RepositoryFactory;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryRegistry;

public class AbstractRepositoryImplConfig
implements RepositoryImplConfig {
    private String type;

    public AbstractRepositoryImplConfig() {
    }

    public AbstractRepositoryImplConfig(String type) {
        this();
        this.setType(type);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void validate() throws RepositoryConfigException {
        if (this.type == null) {
            throw new RepositoryConfigException("No type specified for repository implementation");
        }
    }

    @Override
    public Resource export(Model model) {
        BNode implNode = SimpleValueFactory.getInstance().createBNode();
        if (this.type != null) {
            model.add((Resource)implNode, RepositoryConfigSchema.REPOSITORYTYPE, (Value)SimpleValueFactory.getInstance().createLiteral(this.type), new Resource[0]);
        }
        return implNode;
    }

    @Override
    public void parse(Model model, Resource resource) throws RepositoryConfigException {
        Models.objectLiteral(model.getStatements(resource, RepositoryConfigSchema.REPOSITORYTYPE, null, new Resource[0])).ifPresent(typeLit -> this.setType(typeLit.getLabel()));
    }

    public static RepositoryImplConfig create(Model model, Resource resource) throws RepositoryConfigException {
        try {
            Literal typeLit = Models.objectLiteral(model.getStatements(resource, RepositoryConfigSchema.REPOSITORYTYPE, null, new Resource[0])).orElse(null);
            if (typeLit != null) {
                RepositoryFactory factory = (RepositoryFactory)RepositoryRegistry.getInstance().get(typeLit.getLabel()).orElseThrow(() -> new RepositoryConfigException("Unsupported repository type: " + typeLit.getLabel()));
                RepositoryImplConfig implConfig = factory.getConfig();
                implConfig.parse(model, resource);
                return implConfig;
            }
            return null;
        }
        catch (ModelException e) {
            throw new RepositoryConfigException(e.getMessage(), e);
        }
    }
}

