/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.Stats;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BufferedSplitter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnorderedSelect;

@Deprecated
@InternalUseOnly
public class ConnectionsGroup
implements Closeable {
    private final SailConnection baseConnection;
    private final SailConnection previousStateConnection;
    private final Sail addedStatements;
    private final Sail removedStatements;
    private final ShaclSailConnection.Settings transactionSettings;
    private final Stats stats;
    private final RdfsSubClassOfReasonerProvider rdfsSubClassOfReasonerProvider;
    private final ConcurrentLinkedQueue<SailConnection> connectionsToClose = new ConcurrentLinkedQueue();
    private final Map<PlanNode, BufferedSplitter> nodeCache = new HashMap<PlanNode, BufferedSplitter>();

    ConnectionsGroup(SailConnection baseConnection, SailConnection previousStateConnection, Sail addedStatements, Sail removedStatements, Stats stats, RdfsSubClassOfReasonerProvider rdfsSubClassOfReasonerProvider, ShaclSailConnection.Settings transactionSettings) {
        this.baseConnection = baseConnection;
        this.previousStateConnection = previousStateConnection;
        this.addedStatements = addedStatements;
        this.removedStatements = removedStatements;
        this.stats = stats;
        this.rdfsSubClassOfReasonerProvider = rdfsSubClassOfReasonerProvider;
        this.transactionSettings = transactionSettings;
    }

    public SailConnection getPreviousStateConnection() {
        return this.previousStateConnection;
    }

    public SailConnection getAddedStatements() {
        SailConnection connection = this.addedStatements.getConnection();
        this.connectionsToClose.add(connection);
        return connection;
    }

    public SailConnection getRemovedStatements() {
        SailConnection connection = this.removedStatements.getConnection();
        this.connectionsToClose.add(connection);
        return connection;
    }

    @Override
    public void close() {
        for (SailConnection sailConnection : this.connectionsToClose) {
            sailConnection.close();
        }
    }

    public SailConnection getBaseConnection() {
        return this.baseConnection;
    }

    public synchronized PlanNode getCachedNodeFor(PlanNode planNode) {
        if (!this.transactionSettings.isCacheSelectNodes()) {
            return planNode;
        }
        if (planNode instanceof UnorderedSelect || planNode instanceof UnBufferedPlanNode) {
            return planNode;
        }
        BufferedSplitter bufferedSplitter = this.nodeCache.computeIfAbsent(planNode, BufferedSplitter::new);
        return bufferedSplitter.getPlanNode();
    }

    public RdfsSubClassOfReasoner getRdfsSubClassOfReasoner() {
        return this.rdfsSubClassOfReasonerProvider.getRdfsSubClassOfReasoner();
    }

    public Stats getStats() {
        return this.stats;
    }

    public ShaclSailConnection.Settings getTransactionSettings() {
        return this.transactionSettings;
    }

    static interface RdfsSubClassOfReasonerProvider {
        public RdfsSubClassOfReasoner getRdfsSubClassOfReasoner();
    }
}

