/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.util.Collection;
import org.eclipse.rdf4j.console.command.QueryEvaluator;
import org.eclipse.rdf4j.console.command.TupleAndGraphQueryEvaluator;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.query.parser.serql.SeRQLUtil;

public class Serql
extends QueryEvaluator {
    private static final String NAMESPACE = "USING NAMESPACE";

    @Override
    public String getName() {
        return "serql";
    }

    @Override
    public String getHelpShort() {
        return "Evaluate a SeRQL query";
    }

    @Override
    public String getHelpLong() {
        return "Usage:\nserql                         Starts multi-line input for large SeRQL queries.\nserql <query>                 Evaluates the SeRQL query on the currently open repository\nserql INFILE=\"infile.ext\"            Evaluates the query stored in a file.\nserql OUTFILE=\"outfile.ext\" <query>  Save the results to a file.\n    Supported extensions for graphs: jsonld, nt, ttl, xml\n    Supported extensions for tuples: csv, srj, srx, tsv\nserql INFILE=\"infile.ext\" OUTFILE=\"outfile.ext\" \n";
    }

    public Serql(TupleAndGraphQueryEvaluator evaluator) {
        super(evaluator);
    }

    @Override
    protected boolean hasQueryPrefixes(String query) {
        return query.contains("USING NAMESPACE ");
    }

    @Override
    protected void addQueryPrefixes(StringBuffer result, Collection<Namespace> namespaces) {
        StringBuilder str = new StringBuilder(512);
        str.append(" ").append(NAMESPACE).append(" ");
        for (Namespace namespace : namespaces) {
            str.append(namespace.getPrefix()).append(" = ");
            str.append("<").append(SeRQLUtil.encodeString((String)namespace.getName())).append(">, ");
        }
    }
}

