/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.impl.ListBindingSet;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindSelect
implements PlanNode {
    private static final Logger logger = LoggerFactory.getLogger(BindSelect.class);
    private final SailConnection connection;
    private final Function<BindingSet, ValidationTuple> mapper;
    private final String query;
    private final List<StatementMatcher.Variable> vars;
    private final int bulkSize;
    private final PlanNode source;
    private final EffectiveTarget.Extend direction;
    private final boolean includePropertyShapeValues;
    private final List<String> varNames;
    private final ConstraintComponent.Scope scope;
    private StackTraceElement[] stackTrace;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public BindSelect(SailConnection connection, String query, List<StatementMatcher.Variable> vars, PlanNode source, List<String> varNames, ConstraintComponent.Scope scope, int bulkSize, EffectiveTarget.Extend direction, boolean includePropertyShapeValues) {
        this.connection = connection;
        this.mapper = bindingSet -> new ValidationTuple((BindingSet)bindingSet, varNames, scope, includePropertyShapeValues);
        this.varNames = varNames;
        this.scope = scope;
        this.vars = vars;
        this.bulkSize = bulkSize;
        this.source = source = PlanNodeHelper.handleSorting(this, source);
        if (query.trim().equals("")) {
            throw new IllegalStateException();
        }
        this.query = query;
        this.direction = direction;
        this.includePropertyShapeValues = includePropertyShapeValues;
    }

    private void updateQuery(ParsedQuery parsedQuery, final List<BindingSet> newBindindingset, final int expectedSize) {
        try {
            parsedQuery.getTupleExpr().visit((QueryModelVisitor)new AbstractQueryModelVisitor<Exception>(){

                public void meet(BindingSetAssignment node) throws Exception {
                    Set bindingNames = node.getBindingNames();
                    if (bindingNames.size() == expectedSize) {
                        node.setBindingSets((Iterable)newBindindingset);
                    }
                    super.meet(node);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingSet;
            final CloseableIteration<? extends ValidationTuple, SailException> iterator;
            Integer targetChainSize;
            {
                this.iterator = BindSelect.this.source.iterator();
                this.targetChainSize = null;
            }

            public void calculateNext() {
                int i;
                if (this.bindingSet != null && this.bindingSet.hasNext()) {
                    return;
                }
                if (this.bindingSet != null) {
                    this.bindingSet.close();
                }
                if (!this.iterator.hasNext()) {
                    return;
                }
                ArrayList<Object> bulk = new ArrayList<Object>(BindSelect.this.bulkSize);
                ValidationTuple next = (ValidationTuple)this.iterator.next();
                if (BindSelect.this.includePropertyShapeValues) {
                    assert (next.getScope() == ConstraintComponent.Scope.propertyShape);
                    assert (next.hasValue());
                }
                bulk.add(next);
                int targetChainSize = BindSelect.this.includePropertyShapeValues || next.getScope() != ConstraintComponent.Scope.propertyShape ? next.getFullChainSize() : next.getTargetChain(BindSelect.this.includePropertyShapeValues).size();
                if (this.targetChainSize != null) {
                    assert (targetChainSize == this.targetChainSize);
                } else {
                    this.targetChainSize = targetChainSize;
                }
                StringBuilder orderBy = new StringBuilder();
                StringBuilder values = new StringBuilder("\nVALUES( ");
                if (BindSelect.this.direction == EffectiveTarget.Extend.right) {
                    for (i = 0; i < targetChainSize; ++i) {
                        values.append("?").append(((StatementMatcher.Variable)BindSelect.this.vars.get(i)).getName()).append(" ");
                    }
                } else if (BindSelect.this.direction == EffectiveTarget.Extend.left) {
                    for (i = BindSelect.this.vars.size() - targetChainSize; i < BindSelect.this.vars.size(); ++i) {
                        values.append("?").append(((StatementMatcher.Variable)BindSelect.this.vars.get(i)).getName()).append(" ");
                    }
                } else {
                    throw new IllegalStateException("Unknown direction: " + (Object)((Object)BindSelect.this.direction));
                }
                values.append("){}\n");
                for (StatementMatcher.Variable var : BindSelect.this.vars) {
                    orderBy.append("?").append(var.getName()).append(" ");
                }
                String query = BindSelect.this.query;
                query = query.replace("#VALUES_INJECTION_POINT#", values.toString());
                query = "select * where { " + values.toString() + query + "\n}\nORDER BY " + orderBy;
                QueryParserFactory queryParserFactory = (QueryParserFactory)QueryParserRegistry.getInstance().get((Object)QueryLanguage.SPARQL).get();
                try {
                    ParsedQuery parsedQuery = queryParserFactory.getParser().parseQuery(query, null);
                    for (int i2 = 1; i2 < BindSelect.this.bulkSize && this.iterator.hasNext(); ++i2) {
                        bulk.add(this.iterator.next());
                    }
                    List varNames = BindSelect.this.direction == EffectiveTarget.Extend.right ? BindSelect.this.vars.stream().limit(targetChainSize).map(StatementMatcher.Variable::getName).collect(Collectors.toList()) : BindSelect.this.vars.stream().skip(BindSelect.this.vars.size() - targetChainSize).map(StatementMatcher.Variable::getName).collect(Collectors.toList());
                    List bindingSets = bulk.stream().map(t -> new ListBindingSet(varNames, new ArrayList<Value>(t.getTargetChain(BindSelect.this.includePropertyShapeValues)))).collect(Collectors.toList());
                    BindSelect.this.updateQuery(parsedQuery, bindingSets, targetChainSize);
                    this.bindingSet = BindSelect.this.connection.evaluate(parsedQuery.getTupleExpr(), parsedQuery.getDataset(), (BindingSet)new MapBindingSet(), true);
                }
                catch (MalformedQueryException e) {
                    logger.error("Malformed query: \n{}", (Object)query);
                    throw e;
                }
            }

            public void close() throws SailException {
                try {
                    this.iterator.close();
                }
                finally {
                    if (this.bindingSet != null) {
                        this.bindingSet.close();
                    }
                }
            }

            @Override
            boolean localHasNext() throws SailException {
                this.calculateNext();
                return this.bindingSet != null && this.bindingSet.hasNext();
            }

            @Override
            ValidationTuple loggingNext() throws SailException {
                this.calculateNext();
                return (ValidationTuple)BindSelect.this.mapper.apply(this.bindingSet.next());
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return 0;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        if (this.connection instanceof MemoryStoreConnection) {
            stringBuilder.append(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()) + " -> " + this.getId()).append("\n");
        } else {
            stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId()).append("\n");
        }
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.source.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return false;
    }

    @Override
    public boolean requiresSorted() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BindSelect that = (BindSelect)o;
        if (this.connection instanceof MemoryStoreConnection && that.connection instanceof MemoryStoreConnection) {
            return this.bulkSize == that.bulkSize && this.includePropertyShapeValues == that.includePropertyShapeValues && ((MemoryStoreConnection)this.connection).getSail().equals(((MemoryStoreConnection)that.connection).getSail()) && this.varNames.equals(that.varNames) && this.scope.equals((Object)that.scope) && this.query.equals(that.query) && this.vars.equals(that.vars) && this.source.equals(that.source) && this.direction == that.direction;
        }
        return this.bulkSize == that.bulkSize && this.includePropertyShapeValues == that.includePropertyShapeValues && this.connection.equals(that.connection) && this.varNames.equals(that.varNames) && this.scope.equals((Object)that.scope) && this.query.equals(that.query) && this.vars.equals(that.vars) && this.source.equals(that.source) && this.direction == that.direction;
    }

    public int hashCode() {
        if (this.connection instanceof MemoryStoreConnection) {
            return Objects.hash(new Object[]{((MemoryStoreConnection)this.connection).getSail(), this.varNames, this.scope, this.query, this.vars, this.bulkSize, this.source, this.direction, this.includePropertyShapeValues});
        }
        return Objects.hash(new Object[]{this.connection, this.varNames, this.scope, this.query, this.vars, this.bulkSize, this.source, this.direction, this.includePropertyShapeValues});
    }

    public String toString() {
        return "BindSelect{query='" + this.query + '\'' + ", vars=" + this.vars + ", bulkSize=" + this.bulkSize + ", source=" + this.source + ", direction=" + (Object)((Object)this.direction) + ", includePropertyShapeValues=" + this.includePropertyShapeValues + ", varNames=" + this.varNames + ", scope=" + (Object)((Object)this.scope) + '}';
    }
}

