/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.union;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.evaluation.TripleSource;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelExecutor;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelTaskBase;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.QueryEvaluationException;

public class ParallelGetStatementsTask
extends ParallelTaskBase<Statement> {
    protected final ParallelExecutor<Statement> unionControl;
    protected final Endpoint endpoint;
    protected final Resource subj;
    protected final IRI pred;
    protected final Value obj;
    protected final QueryInfo queryInfo;
    protected Resource[] contexts;

    public ParallelGetStatementsTask(ParallelExecutor<Statement> unionControl, Endpoint endpoint, Resource subj, IRI pred, Value obj, QueryInfo queryInfo, Resource ... contexts) {
        this.unionControl = unionControl;
        this.endpoint = endpoint;
        this.subj = subj;
        this.pred = pred;
        this.obj = obj;
        this.queryInfo = queryInfo;
        this.contexts = contexts;
    }

    @Override
    public ParallelExecutor<Statement> getControl() {
        return this.unionControl;
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> performTask() throws Exception {
        TripleSource tripleSource = this.endpoint.getTripleSource();
        return tripleSource.getStatements(this.subj, this.pred, this.obj, this.queryInfo, this.contexts);
    }
}

