/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.lang.ref.WeakReference;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;

public abstract class QueueIteration<E, T extends Exception>
extends LookAheadIteration<E, T> {
    private final AtomicBoolean done = new AtomicBoolean(false);
    private final BlockingQueue<E> queue;
    private final E afterLast = this.createAfterLast();
    private final Queue<Exception> exceptions = new ConcurrentLinkedQueue<Exception>();
    private final WeakReference<?> callerRef;

    protected QueueIteration(int capacity, WeakReference<?> callerRef) {
        this(capacity, false, callerRef);
    }

    protected QueueIteration(int capacity, boolean fair, WeakReference<?> callerRef) {
        this.callerRef = callerRef;
        this.queue = new ArrayBlockingQueue(capacity, fair);
    }

    protected QueueIteration(BlockingQueue<E> queue, WeakReference<?> callerRef) {
        this.queue = queue;
        this.callerRef = callerRef;
    }

    protected abstract T convert(Exception var1);

    public void toss(Exception exception) {
        this.exceptions.add(exception);
    }

    public void put(E item) throws InterruptedException, T {
        try {
            while (!(this.isClosed() || this.done.get() || Thread.currentThread().isInterrupted() || this.queue.offer(item, 1L, TimeUnit.SECONDS))) {
                if (this.callerRef.get() != null) continue;
                this.close();
            }
            if (this.done.get() || Thread.currentThread().isInterrupted()) {
                this.close();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.close();
            throw e;
        }
    }

    public void done() {
        this.done.lazySet(true);
        boolean offer = this.queue.offer(this.afterLast);
        if (!offer) {
            // empty if block
        }
    }

    @Override
    public E getNextElement() throws T {
        if (this.isClosed()) {
            return null;
        }
        try {
            Object take;
            this.checkException();
            if (this.done.get()) {
                take = this.queue.poll();
            } else {
                take = this.queue.take();
                if (this.done.get()) {
                    this.done();
                }
            }
            if (this.isAfterLast(take)) {
                this.done();
                this.checkException();
                return null;
            }
            this.checkException();
            return take;
        }
        catch (InterruptedException e) {
            this.checkException();
            this.close();
            throw this.convert(e);
        }
    }

    @Override
    public void handleClose() throws T {
        try {
            super.handleClose();
        }
        finally {
            this.done.set(true);
            do {
                this.queue.clear();
            } while (!this.queue.offer(this.afterLast));
            this.checkException();
        }
    }

    public void checkException() throws T {
        if (!this.exceptions.isEmpty()) {
            try {
                this.close();
                throw this.exceptions.remove();
            }
            catch (Exception e) {
                throw this.convert(e);
            }
        }
    }

    private boolean isAfterLast(E take) {
        return take == null || take == this.afterLast;
    }

    private E createAfterLast() {
        return (E)new Object();
    }
}

