/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.AbstractBindingSet;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.impl.SimpleBinding;

class SimpleBindingSet
extends AbstractBindingSet {
    private final Binding[] bindings;
    private final Set<String> bindingNamesSet;

    public SimpleBindingSet(Set<String> bindingNamesSet, List<String> varNamesList, List<Value> values) {
        assert (varNamesList.size() == values.size());
        this.bindings = new Binding[varNamesList.size()];
        this.bindingNamesSet = Collections.unmodifiableSet(bindingNamesSet);
        for (int i = 0; i < varNamesList.size(); ++i) {
            this.bindings[i] = new SimpleBinding(varNamesList.get(i), values.get(i));
        }
    }

    public Iterator<Binding> iterator() {
        return Arrays.asList(this.bindings).iterator();
    }

    public Set<String> getBindingNames() {
        return this.bindingNamesSet;
    }

    public Binding getBinding(String bindingName) {
        for (Binding binding : this.bindings) {
            if (!binding.getName().equals(bindingName)) continue;
            return binding;
        }
        return null;
    }

    public boolean hasBinding(String bindingName) {
        return this.bindingNamesSet.contains(bindingName);
    }

    public Value getValue(String bindingName) {
        Binding binding = this.getBinding(bindingName);
        if (binding != null) {
            return binding.getValue();
        }
        return null;
    }

    public int size() {
        return this.bindings.length;
    }
}

