/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.model.MemStatement;
import org.eclipse.rdf4j.sail.memory.model.MemStatementIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemStatementIteratorCache {
    private static final Logger logger = LoggerFactory.getLogger(MemStatementIteratorCache.class);
    public final int CACHE_FREQUENCY_THRESHOLD;
    private final ConcurrentHashMap<MemStatementIterator, Integer> iteratorFrequencyMap = new ConcurrentHashMap();
    private final Cache<MemStatementIterator, List<MemStatement>> iteratorCache = CacheBuilder.newBuilder().softValues().build();

    public MemStatementIteratorCache(int cacheFrequencyThreshold) {
        this.CACHE_FREQUENCY_THRESHOLD = cacheFrequencyThreshold;
    }

    public void invalidateCache() {
        if (!this.iteratorFrequencyMap.isEmpty()) {
            this.iteratorFrequencyMap.clear();
            this.iteratorCache.invalidateAll();
            this.iteratorCache.cleanUp();
            if (logger.isTraceEnabled()) {
                logger.debug("Invalidated cache", new Throwable());
            } else if (logger.isDebugEnabled()) {
                logger.debug("Invalidated cache");
            }
        }
    }

    void incrementIteratorFrequencyMap(MemStatementIterator iterator) {
        Integer compute = this.iteratorFrequencyMap.compute(iterator, (key, value) -> {
            if (value == null) {
                return 0;
            }
            return value + 1;
        });
        if (logger.isDebugEnabled()) {
            logger.debug("Incremented iteratorFrequencyMap to {}\n{} \n{}", new Object[]{compute, iterator, iterator.getStats()});
        }
    }

    boolean shouldBeCached(MemStatementIterator iterator) {
        if (!this.iteratorFrequencyMap.isEmpty()) {
            Integer integer = this.iteratorFrequencyMap.get(iterator);
            return integer != null && integer > this.CACHE_FREQUENCY_THRESHOLD;
        }
        return false;
    }

    CachedIteration getCachedIterator(MemStatementIterator iterator) {
        List cached = (List)this.iteratorCache.getIfPresent((Object)iterator);
        if (cached == null) {
            try (MemStatementIterator memStatementIterator = iterator;){
                logger.debug("Filling cache {}", (Object)iterator);
                ArrayList<MemStatement> newCache = new ArrayList<MemStatement>();
                while (iterator.hasNext()) {
                    newCache.add(iterator.next());
                }
                newCache.trimToSize();
                cached = Collections.unmodifiableList(newCache);
            }
            this.iteratorCache.put((Object)iterator, cached);
        }
        return new CachedIteration(cached.iterator());
    }

    private static class CachedIteration
    implements CloseableIteration<MemStatement, SailException> {
        private Iterator<MemStatement> iter;

        public CachedIteration(Iterator<MemStatement> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() throws SailException {
            if (this.iter == null) {
                return false;
            }
            boolean result = this.iter.hasNext();
            if (!result) {
                this.close();
            }
            return result;
        }

        @Override
        public MemStatement next() throws SailException {
            if (this.iter == null) {
                throw new NoSuchElementException("Iteration has been closed");
            }
            return this.iter.next();
        }

        @Override
        public void remove() throws SailException {
            if (this.iter == null) {
                throw new IllegalStateException("Iteration has been closed");
            }
            this.iter.remove();
        }

        @Override
        public final void close() throws SailException {
            this.iter = null;
        }
    }
}

