/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.context.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import no.hasmac.jsonld.context.cache.Cache;

public final class ConcurrentLruCache<K, V>
implements Cache<K, V> {
    private final Map<K, V> cache;

    public ConcurrentLruCache(final int maxCapacity) {
        this.cache = new LinkedHashMap<K, V>((int)((double)maxCapacity / 0.75 + 1.0), 0.75f, true){
            private static final long serialVersionUID = 4822962879473741809L;

            @Override
            protected synchronized boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > maxCapacity;
            }
        };
    }

    @Override
    public synchronized boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    @Override
    public synchronized V get(K key) {
        return this.cache.get(key);
    }

    @Override
    public synchronized void put(K key, V value) {
        this.cache.put(key, value);
    }

    public synchronized long size() {
        return this.cache.size();
    }
}

