/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.sail.SailException;

class SailCloseableIteration<E>
implements CloseableIteration<E> {
    private final CloseableIteration<? extends E> iter;

    public SailCloseableIteration(CloseableIteration<? extends E> iter) {
        this.iter = iter;
    }

    public void close() {
        try {
            this.iter.close();
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    public boolean hasNext() {
        try {
            return this.iter.hasNext();
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    public E next() {
        try {
            return (E)this.iter.next();
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    public void remove() {
        try {
            this.iter.remove();
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    protected RepositoryException convert(Exception e) {
        if (e instanceof SailException) {
            return new RepositoryException((Throwable)e);
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e == null) {
            throw new IllegalArgumentException("e must not be null");
        }
        throw new IllegalArgumentException("Unexpected exception type: " + e.getClass());
    }
}

