/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.util;

import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.algebra.MathExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.util.MathUtil;

public class XMLDatatypeMathUtil {
    public static Literal compute(Literal leftLit, Literal rightLit, MathExpr.MathOp op) throws ValueExprEvaluationException {
        return XMLDatatypeMathUtil.compute(leftLit, rightLit, op, (ValueFactory)SimpleValueFactory.getInstance());
    }

    public static Literal compute(Literal leftLit, Literal rightLit, MathExpr.MathOp op, ValueFactory vf) throws ValueExprEvaluationException {
        CoreDatatype.XSD leftDatatype = leftLit.getCoreDatatype().asXSDDatatypeOrNull();
        CoreDatatype.XSD rightDatatype = rightLit.getCoreDatatype().asXSDDatatypeOrNull();
        if (leftDatatype != null && rightDatatype != null) {
            if (leftDatatype.isNumericDatatype() && rightDatatype.isNumericDatatype()) {
                return MathUtil.compute(leftLit, rightLit, op, vf);
            }
            if (leftDatatype.isDurationDatatype() && rightDatatype.isDurationDatatype()) {
                return XMLDatatypeMathUtil.operationsBetweenDurations(leftLit, rightLit, op, vf);
            }
            if (leftDatatype.isDecimalDatatype() && rightDatatype.isDurationDatatype()) {
                return XMLDatatypeMathUtil.operationsBetweenDurationAndDecimal(rightLit, leftLit, op, vf);
            }
            if (leftDatatype.isDurationDatatype() && rightDatatype.isDecimalDatatype()) {
                return XMLDatatypeMathUtil.operationsBetweenDurationAndDecimal(leftLit, rightLit, op, vf);
            }
            if (leftDatatype.isCalendarDatatype() && rightDatatype.isDurationDatatype()) {
                return XMLDatatypeMathUtil.operationsBetweenCalendarAndDuration(leftLit, rightLit, op, vf);
            }
            if (leftDatatype.isDurationDatatype() && rightDatatype.isCalendarDatatype()) {
                return XMLDatatypeMathUtil.operationsBetweenDurationAndCalendar(leftLit, rightLit, op, vf);
            }
        }
        throw new ValueExprEvaluationException("Mathematical operators are not supported on these operands");
    }

    private static Literal operationsBetweenDurations(Literal leftLit, Literal rightLit, MathExpr.MathOp op, ValueFactory vf) {
        Duration left = XMLDatatypeUtil.parseDuration((String)leftLit.getLabel());
        Duration right = XMLDatatypeUtil.parseDuration((String)rightLit.getLabel());
        try {
            switch (op) {
                case PLUS: {
                    return XMLDatatypeMathUtil.buildLiteral(left.add(right), vf);
                }
                case MINUS: {
                    return XMLDatatypeMathUtil.buildLiteral(left.subtract(right), vf);
                }
                case MULTIPLY: {
                    throw new ValueExprEvaluationException("Multiplication is not defined on xsd:duration.");
                }
                case DIVIDE: {
                    throw new ValueExprEvaluationException("Division is not defined on xsd:duration.");
                }
            }
            throw new IllegalArgumentException("Unknown operator: " + op);
        }
        catch (IllegalStateException e) {
            throw new ValueExprEvaluationException(e);
        }
    }

    private static Literal operationsBetweenDurationAndDecimal(Literal durationLit, Literal decimalLit, MathExpr.MathOp op, ValueFactory vf) {
        Duration duration = XMLDatatypeUtil.parseDuration((String)durationLit.getLabel());
        try {
            if (op == MathExpr.MathOp.MULTIPLY) {
                return XMLDatatypeMathUtil.buildLiteral(duration.multiply(decimalLit.decimalValue()), vf);
            }
            throw new ValueExprEvaluationException("Only multiplication is defined between xsd:decimal and xsd:duration.");
        }
        catch (IllegalStateException e) {
            throw new ValueExprEvaluationException(e);
        }
    }

    private static Literal operationsBetweenCalendarAndDuration(Literal calendarLit, Literal durationLit, MathExpr.MathOp op, ValueFactory vf) {
        XMLGregorianCalendar calendar = (XMLGregorianCalendar)calendarLit.calendarValue().clone();
        Duration duration = XMLDatatypeUtil.parseDuration((String)durationLit.getLabel());
        try {
            switch (op) {
                case PLUS: {
                    calendar.add(duration);
                    return vf.createLiteral(calendar);
                }
                case MINUS: {
                    calendar.add(duration.negate());
                    return vf.createLiteral(calendar);
                }
                case MULTIPLY: {
                    throw new ValueExprEvaluationException("Multiplication is not defined between xsd:duration and calendar values.");
                }
                case DIVIDE: {
                    throw new ValueExprEvaluationException("Division is not defined between xsd:duration and calendar values.");
                }
            }
            throw new IllegalArgumentException("Unknown operator: " + op);
        }
        catch (IllegalStateException e) {
            throw new ValueExprEvaluationException(e);
        }
    }

    private static Literal operationsBetweenDurationAndCalendar(Literal durationLit, Literal calendarLit, MathExpr.MathOp op, ValueFactory vf) {
        Duration duration = XMLDatatypeUtil.parseDuration((String)durationLit.getLabel());
        XMLGregorianCalendar calendar = (XMLGregorianCalendar)calendarLit.calendarValue().clone();
        try {
            if (op == MathExpr.MathOp.PLUS) {
                calendar.add(duration);
                return vf.createLiteral(calendar);
            }
            throw new ValueExprEvaluationException("Only addition is defined between xsd:duration and calendar datatypes.");
        }
        catch (IllegalStateException e) {
            throw new ValueExprEvaluationException(e);
        }
    }

    private static Literal buildLiteral(Duration duration, ValueFactory vf) {
        return vf.createLiteral(duration.toString(), (CoreDatatype)XMLDatatypeMathUtil.getDatatypeForDuration(duration));
    }

    private static CoreDatatype.XSD getDatatypeForDuration(Duration duration) {
        boolean yearSet = duration.isSet(DatatypeConstants.YEARS);
        boolean monthSet = duration.isSet(DatatypeConstants.MONTHS);
        boolean daySet = duration.isSet(DatatypeConstants.DAYS);
        boolean hourSet = duration.isSet(DatatypeConstants.HOURS);
        boolean minuteSet = duration.isSet(DatatypeConstants.MINUTES);
        boolean secondSet = duration.isSet(DatatypeConstants.SECONDS);
        if (!yearSet && !monthSet) {
            return CoreDatatype.XSD.DAYTIMEDURATION;
        }
        if (!(daySet || hourSet || minuteSet || secondSet)) {
            return CoreDatatype.XSD.YEARMONTHDURATION;
        }
        return CoreDatatype.XSD.DURATION;
    }
}

