/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.xsd;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtility;

public abstract class CastFunction
implements Function {
    @Override
    public final String getURI() {
        return this.getCoreXsdDatatype().getIri().toString();
    }

    @Override
    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException(this.getXsdName() + " cast requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            CoreDatatype datatype = literal.getCoreDatatype();
            if (QueryEvaluationUtility.isStringLiteral(literal)) {
                String lexicalValue = XMLDatatypeUtil.collapseWhiteSpace(literal.getLabel());
                if (this.isValidForDatatype(lexicalValue)) {
                    return valueFactory.createLiteral(lexicalValue, this.getCoreXsdDatatype());
                }
            } else if (datatype != null && datatype == this.getCoreXsdDatatype()) {
                return literal;
            }
            return this.convert(valueFactory, literal);
        }
        return this.convert(valueFactory, args[0]);
    }

    protected abstract Literal convert(ValueFactory var1, Value var2) throws ValueExprEvaluationException;

    @Deprecated(since="5.0.0", forRemoval=true)
    protected IRI getXsdDatatype() {
        return this.getCoreXsdDatatype().getIri();
    }

    protected abstract CoreDatatype.XSD getCoreXsdDatatype();

    protected String getXsdName() {
        return "xsd:" + this.getCoreXsdDatatype().getIri().getLocalName();
    }

    protected abstract boolean isValidForDatatype(String var1);

    protected final ValueExprEvaluationException typeError(Value arg, Throwable cause) {
        return new ValueExprEvaluationException("Invalid argument for " + this.getXsdName() + " cast: " + arg, cause);
    }
}

