/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.core;

import java.util.ArrayList;
import org.eclipse.rdf4j.sparqlbuilder.core.Projectable;
import org.eclipse.rdf4j.sparqlbuilder.core.QueryElementCollection;

public class Projection
extends QueryElementCollection<Projectable> {
    private static final String SELECT = "SELECT";
    private static final String DISTINCT = "DISTINCT";
    private static final String DELIMETER = " ";
    private boolean isDistinct;
    private boolean selectAll;

    Projection() {
        super(DELIMETER, new ArrayList());
        this.all(false);
        this.distinct(false);
    }

    public Projection distinct() {
        return this.distinct(true);
    }

    public Projection distinct(boolean isDistinct) {
        this.isDistinct = isDistinct;
        return this;
    }

    public Projection all() {
        return this.all(true);
    }

    public Projection all(boolean selectAll) {
        this.selectAll = selectAll;
        return this;
    }

    public Projection select(Projectable ... projectables) {
        this.addElements(projectables);
        return this;
    }

    @Override
    public String getQueryString() {
        StringBuilder selectStatement = new StringBuilder();
        selectStatement.append(SELECT).append(DELIMETER);
        if (this.selectAll || this.isEmpty()) {
            selectStatement.append("*").append(DELIMETER);
        } else {
            if (this.isDistinct) {
                selectStatement.append(DISTINCT).append(DELIMETER);
            }
            selectStatement.append(super.getQueryString());
        }
        return selectStatement.toString();
    }
}

