/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.map.primitive.MutableByteObjectMapFactory;
import org.eclipse.collections.api.map.primitive.ByteObjectMap;
import org.eclipse.collections.api.map.primitive.MutableByteObjectMap;
import org.eclipse.collections.impl.factory.primitive.ByteObjectMaps;
import org.eclipse.collections.impl.map.mutable.primitive.ByteObjectHashMap;
import org.eclipse.collections.impl.utility.Iterate;

public enum MutableByteObjectMapFactoryImpl implements MutableByteObjectMapFactory
{
    INSTANCE;


    public <V> MutableByteObjectMap<V> empty() {
        return new ByteObjectHashMap(0);
    }

    public <V> MutableByteObjectMap<V> of() {
        return this.empty();
    }

    public <V> MutableByteObjectMap<V> with() {
        return this.empty();
    }

    public <V> MutableByteObjectMap<V> ofInitialCapacity(int capacity) {
        return this.withInitialCapacity(capacity);
    }

    public <V> MutableByteObjectMap<V> withInitialCapacity(int capacity) {
        return new ByteObjectHashMap(capacity);
    }

    public <V> MutableByteObjectMap<V> ofAll(ByteObjectMap<? extends V> map) {
        return this.withAll(map);
    }

    public <V> MutableByteObjectMap<V> withAll(ByteObjectMap<? extends V> map) {
        if (map.isEmpty()) {
            return this.empty();
        }
        return new ByteObjectHashMap<V>(map);
    }

    public <T, V> MutableByteObjectMap<V> from(Iterable<T> iterable, ByteFunction<? super T> keyFunction, Function<? super T, ? extends V> valueFunction) {
        MutableByteObjectMap map = ByteObjectMaps.mutable.empty();
        Iterate.forEach(iterable, (Procedure & Serializable)each -> map.put(keyFunction.byteValueOf(each), valueFunction.valueOf(each)));
        return map;
    }
}

