/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.util;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InternalUseOnly
public class Configurations {
    private static final Logger logger = LoggerFactory.getLogger(Configurations.class);

    public static boolean useLegacyConfig() {
        return "true".equalsIgnoreCase(System.getProperty("org.eclipse.rdf4j.model.vocabulary.useLegacyConfig"));
    }

    public static boolean hasLegacyConfiguration(Model configModel) {
        return configModel.predicates().stream().anyMatch(p -> p.stringValue().startsWith("http://www.openrdf.org/config"));
    }

    @InternalUseOnly
    public static Optional<Resource> getResourceValue(Model model, Resource subject, IRI property, IRI legacyProperty) {
        IRI preferredProperty = Configurations.useLegacyConfig() ? legacyProperty : property;
        IRI fallbackProperty = Configurations.useLegacyConfig() ? property : legacyProperty;
        Optional<Resource> preferredResult = Models.objectResource(model.getStatements(subject, preferredProperty, null, new Resource[0]));
        Optional<Resource> fallbackResult = Models.objectResource(model.getStatements(subject, fallbackProperty, null, new Resource[0]));
        Configurations.logDiscrepancyWarning(preferredResult, fallbackResult);
        if (preferredResult.isPresent()) {
            return preferredResult;
        }
        return fallbackResult;
    }

    @InternalUseOnly
    public static Optional<Literal> getLiteralValue(Model model, Resource subject, IRI property, IRI legacyProperty) {
        IRI preferredProperty = Configurations.useLegacyConfig() ? legacyProperty : property;
        IRI fallbackProperty = Configurations.useLegacyConfig() ? property : legacyProperty;
        Optional<Literal> preferredResult = Models.objectLiteral(model.getStatements(subject, preferredProperty, null, new Resource[0]));
        Optional<Literal> fallbackResult = Models.objectLiteral(model.getStatements(subject, fallbackProperty, null, new Resource[0]));
        Configurations.logDiscrepancyWarning(preferredResult, fallbackResult);
        if (preferredResult.isPresent()) {
            return preferredResult;
        }
        return fallbackResult;
    }

    @InternalUseOnly
    public static Optional<Value> getValue(Model model, Resource subject, IRI property, IRI legacyProperty) {
        IRI preferredProperty = Configurations.useLegacyConfig() ? legacyProperty : property;
        IRI fallbackProperty = Configurations.useLegacyConfig() ? property : legacyProperty;
        Optional<Value> preferredResult = Models.object(model.getStatements(subject, preferredProperty, null, new Resource[0]));
        Optional<Value> fallbackResult = Models.object(model.getStatements(subject, fallbackProperty, null, new Resource[0]));
        Configurations.logDiscrepancyWarning(preferredResult, fallbackResult);
        if (preferredResult.isPresent()) {
            return preferredResult;
        }
        return fallbackResult;
    }

    @InternalUseOnly
    public static Set<Value> getPropertyValues(Model model, Resource subject, IRI property, IRI legacyProperty) {
        IRI preferredProperty = Configurations.useLegacyConfig() ? legacyProperty : property;
        IRI fallbackProperty = Configurations.useLegacyConfig() ? property : legacyProperty;
        Set<Value> preferredObjects = model.filter(subject, preferredProperty, null, new Resource[0]).objects();
        Set<Value> fallbackObjects = model.filter(subject, fallbackProperty, null, new Resource[0]).objects();
        if (!fallbackObjects.isEmpty() && !preferredObjects.equals(fallbackObjects)) {
            String msg = "Discrepancy between use of the old and new config vocabulary.";
            if (preferredObjects.isEmpty()) {
                logger.debug(msg);
            } else {
                logger.warn(msg);
            }
            if (preferredObjects.containsAll(fallbackObjects)) {
                return preferredObjects;
            }
            if (fallbackObjects.containsAll(preferredObjects)) {
                return fallbackObjects;
            }
            HashSet<Value> results = new HashSet<Value>(preferredObjects);
            results.addAll(fallbackObjects);
            return results;
        }
        return preferredObjects;
    }

    @InternalUseOnly
    public static Optional<IRI> getIRIValue(Model model, Resource subject, IRI property, IRI legacyProperty) {
        IRI preferredProperty = Configurations.useLegacyConfig() ? legacyProperty : property;
        IRI fallbackProperty = Configurations.useLegacyConfig() ? property : legacyProperty;
        Optional<IRI> preferredResult = Models.objectIRI(model.getStatements(subject, preferredProperty, null, new Resource[0]));
        Optional<IRI> fallbackResult = Models.objectIRI(model.getStatements(subject, fallbackProperty, null, new Resource[0]));
        Configurations.logDiscrepancyWarning(preferredResult, fallbackResult);
        if (preferredResult.isPresent()) {
            return preferredResult;
        }
        return fallbackResult;
    }

    @InternalUseOnly
    public static Optional<Resource> getSubjectByType(Model model, IRI type, IRI legacyType) {
        IRI preferredType = Configurations.useLegacyConfig() ? legacyType : type;
        IRI fallbackType = Configurations.useLegacyConfig() ? type : legacyType;
        Optional<Resource> preferredResult = Models.subject(model.getStatements(null, RDF.TYPE, preferredType, new Resource[0]));
        Optional<Resource> fallbackResult = Models.subject(model.getStatements(null, RDF.TYPE, fallbackType, new Resource[0]));
        Configurations.logDiscrepancyWarning(preferredResult, fallbackResult);
        if (preferredResult.isPresent()) {
            return preferredResult;
        }
        return fallbackResult;
    }

    private static void logDiscrepancyWarning(Optional<? extends Value> preferred, Optional<? extends Value> fallback) {
        if (!fallback.isEmpty() && !preferred.equals(fallback)) {
            String msg = "Discrepancy between use of the old and new config vocabulary.";
            if (preferred.isEmpty()) {
                logger.debug(msg);
            } else {
                logger.warn(msg);
            }
        }
    }
}

