/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.rdf4j.common.io.Sink;
import org.eclipse.rdf4j.common.lang.FileFormat;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.resultio.QueryResultWriter;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.ValueMappingBindingSet;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.RDFStarUtil;

public abstract class AbstractQueryResultWriter
implements QueryResultWriter,
Sink {
    private WriterConfig writerConfig = new WriterConfig();
    private boolean encodeRDFStar;

    @Override
    public void setWriterConfig(WriterConfig config) {
        this.writerConfig = config;
    }

    @Override
    public WriterConfig getWriterConfig() {
        return this.writerConfig;
    }

    @Override
    public Collection<RioSetting<?>> getSupportedSettings() {
        return Arrays.asList(BasicWriterSettings.ENCODE_RDF_STAR, BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL);
    }

    public FileFormat getFileFormat() {
        return this.getQueryResultFormat();
    }

    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        this.encodeRDFStar = this instanceof TupleQueryResultWriter && !((TupleQueryResultWriter)((Object)this)).getTupleQueryResultFormat().supportsRDFStar() && (Boolean)this.getWriterConfig().get((RioSetting)BasicWriterSettings.ENCODE_RDF_STAR) != false;
    }

    public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        if (this.encodeRDFStar) {
            this.handleSolutionImpl((BindingSet)new ValueMappingBindingSet(bindingSet, RDFStarUtil::toRDFEncodedValue));
        } else {
            this.handleSolutionImpl(bindingSet);
        }
    }

    protected void handleSolutionImpl(BindingSet bindings) throws TupleQueryResultHandlerException {
        throw new UnsupportedOperationException();
    }

    protected boolean xsdStringToPlainLiteral() {
        return (Boolean)this.getWriterConfig().get((RioSetting)BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL);
    }
}

