/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.util;

import java.util.Objects;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.query.algebra.Compare;

@InternalUseOnly
public class QueryEvaluationUtility {
    public static Result getEffectiveBooleanValue(Value value) {
        if (value.isLiteral()) {
            Literal literal = (Literal)value;
            String label = literal.getLabel();
            CoreDatatype.XSD datatype = literal.getCoreDatatype().asXSDDatatypeOrNull();
            if (datatype == CoreDatatype.XSD.STRING) {
                return Result.fromBoolean(!label.isEmpty());
            }
            if (datatype == CoreDatatype.XSD.BOOLEAN) {
                return Result.fromBoolean("true".equals(label) || "1".equals(label));
            }
            if (datatype == CoreDatatype.XSD.DECIMAL) {
                try {
                    String normDec = XMLDatatypeUtil.normalizeDecimal(label);
                    return Result.fromBoolean(!normDec.equals("0.0"));
                }
                catch (IllegalArgumentException e) {
                    return Result.fromBoolean(false);
                }
            }
            if (datatype != null && datatype.isIntegerDatatype()) {
                try {
                    String normInt = XMLDatatypeUtil.normalize(label, datatype);
                    return Result.fromBoolean(!normInt.equals("0"));
                }
                catch (IllegalArgumentException e) {
                    return Result.fromBoolean(false);
                }
            }
            if (datatype != null && datatype.isFloatingPointDatatype()) {
                try {
                    String normFP = XMLDatatypeUtil.normalize(label, datatype);
                    return Result.fromBoolean(!normFP.equals("0.0E0") && !normFP.equals("NaN"));
                }
                catch (IllegalArgumentException e) {
                    return Result.fromBoolean(false);
                }
            }
        }
        return Result.incompatibleValueExpression;
    }

    public static Result compare(Value leftVal, Value rightVal, Compare.CompareOp operator) {
        return QueryEvaluationUtility.compare(leftVal, rightVal, operator, true);
    }

    public static Result compare(Value leftVal, Value rightVal, Compare.CompareOp operator, boolean strict) {
        if (leftVal.isLiteral() && rightVal.isLiteral()) {
            return QueryEvaluationUtility.compareLiterals((Literal)leftVal, (Literal)rightVal, operator, strict);
        }
        switch (operator) {
            case EQ: {
                return Result.fromBoolean(Objects.equals(leftVal, rightVal));
            }
            case NE: {
                return Result.fromBoolean(!Objects.equals(leftVal, rightVal));
            }
        }
        return Result.incompatibleValueExpression;
    }

    public static Result compareLiterals(Literal leftLit, Literal rightLit, Compare.CompareOp operator) {
        return QueryEvaluationUtility.compareLiterals(leftLit, rightLit, operator, true);
    }

    public static Order compareLiterals(Literal leftLit, Literal rightLit, boolean strict) {
        CoreDatatype.XSD rightXSDDatatype;
        CoreDatatype.XSD leftXSDDatatype;
        boolean rightLangLit;
        boolean leftLangLit;
        block6: {
            CoreDatatype.XSD commonDatatype;
            CoreDatatype leftCoreDatatype = leftLit.getCoreDatatype();
            CoreDatatype rightCoreDatatype = rightLit.getCoreDatatype();
            leftLangLit = leftCoreDatatype == CoreDatatype.RDF.LANGSTRING;
            rightLangLit = rightCoreDatatype == CoreDatatype.RDF.LANGSTRING;
            leftXSDDatatype = leftCoreDatatype.asXSDDatatype().orElse(null);
            rightXSDDatatype = rightCoreDatatype.asXSDDatatype().orElse(null);
            if (leftCoreDatatype == CoreDatatype.XSD.STRING && rightCoreDatatype == CoreDatatype.XSD.STRING) {
                return Order.from(leftLit.getLabel().compareTo(rightLit.getLabel()));
            }
            if (!leftLangLit && !rightLangLit && (commonDatatype = QueryEvaluationUtility.getCommonDatatype(strict, leftXSDDatatype, rightXSDDatatype)) != null) {
                try {
                    Order order = QueryEvaluationUtility.handleCommonDatatype(leftLit, rightLit, strict, leftXSDDatatype, rightXSDDatatype, leftLangLit, rightLangLit, commonDatatype);
                    if (order == Order.illegalArgument && leftLit.equals(rightLit)) {
                        return Order.equal;
                    }
                    if (order != null) {
                        return order;
                    }
                }
                catch (IllegalArgumentException e) {
                    if (!leftLit.equals(rightLit)) break block6;
                    return Order.equal;
                }
            }
        }
        return QueryEvaluationUtility.otherCases(leftLit, rightLit, leftXSDDatatype, rightXSDDatatype, leftLangLit, rightLangLit);
    }

    public static Result compareLiterals(Literal leftLit, Literal rightLit, Compare.CompareOp operator, boolean strict) {
        Order order = QueryEvaluationUtility.compareLiterals(leftLit, rightLit, strict);
        return order.toResult(operator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Order handleCommonDatatype(Literal leftLit, Literal rightLit, boolean strict, CoreDatatype.XSD leftCoreDatatype, CoreDatatype.XSD rightCoreDatatype, boolean leftLangLit, boolean rightLangLit, CoreDatatype.XSD commonDatatype) {
        if (commonDatatype == CoreDatatype.XSD.DOUBLE) {
            return Order.from(Double.compare(leftLit.doubleValue(), rightLit.doubleValue()));
        }
        if (commonDatatype == CoreDatatype.XSD.FLOAT) {
            return Order.from(Float.compare(leftLit.floatValue(), rightLit.floatValue()));
        }
        if (commonDatatype == CoreDatatype.XSD.DECIMAL) {
            return Order.from(leftLit.decimalValue().compareTo(rightLit.decimalValue()));
        }
        if (commonDatatype.isIntegerDatatype()) {
            return Order.from(leftLit.integerValue().compareTo(rightLit.integerValue()));
        }
        if (commonDatatype == CoreDatatype.XSD.BOOLEAN) {
            return Order.from(Boolean.compare(leftLit.booleanValue(), rightLit.booleanValue()));
        }
        if (commonDatatype.isCalendarDatatype()) {
            XMLGregorianCalendar right;
            XMLGregorianCalendar left = leftLit.calendarValue();
            int compare = left.compare(right = rightLit.calendarValue());
            if (compare != 2) return Order.from(compare);
            if (leftCoreDatatype != CoreDatatype.XSD.DATETIME || rightCoreDatatype != CoreDatatype.XSD.DATETIME) return null;
            return Order.incompatibleValueExpression;
        }
        if (!strict && commonDatatype.isDurationDatatype()) {
            Duration right;
            Duration left = XMLDatatypeUtil.parseDuration(leftLit.getLabel());
            int compare = left.compare(right = XMLDatatypeUtil.parseDuration(rightLit.getLabel()));
            if (compare == 2) return QueryEvaluationUtility.otherCases(leftLit, rightLit, leftCoreDatatype, rightCoreDatatype, leftLangLit, rightLangLit);
            return Order.from(compare);
        }
        if (commonDatatype != CoreDatatype.XSD.STRING) return null;
        return Order.from(leftLit.getLabel().compareTo(rightLit.getLabel()));
    }

    private static Order otherCases(Literal leftLit, Literal rightLit, CoreDatatype.XSD leftCoreDatatype, CoreDatatype.XSD rightCoreDatatype, boolean leftLangLit, boolean rightLangLit) {
        boolean literalsEqual = leftLit.equals(rightLit);
        if (!literalsEqual) {
            if (!leftLangLit && !rightLangLit && QueryEvaluationUtility.isSupportedDatatype(leftCoreDatatype) && QueryEvaluationUtility.isSupportedDatatype(rightCoreDatatype)) {
                if (!XMLDatatypeUtil.isValidValue(leftLit.getLabel(), leftCoreDatatype)) {
                    return Order.incompatibleValueExpression;
                }
                if (!XMLDatatypeUtil.isValidValue(rightLit.getLabel(), rightCoreDatatype)) {
                    return Order.incompatibleValueExpression;
                }
                boolean leftString = leftCoreDatatype == CoreDatatype.XSD.STRING;
                boolean leftNumeric = leftCoreDatatype.isNumericDatatype();
                boolean leftDate = leftCoreDatatype.isCalendarDatatype();
                boolean rightString = rightCoreDatatype == CoreDatatype.XSD.STRING;
                boolean rightNumeric = rightCoreDatatype.isNumericDatatype();
                boolean rightDate = rightCoreDatatype.isCalendarDatatype();
                if (leftString != rightString) {
                    return Order.incompatibleValueExpression;
                }
                if (leftNumeric != rightNumeric) {
                    return Order.incompatibleValueExpression;
                }
                if (leftDate != rightDate) {
                    return Order.incompatibleValueExpression;
                }
            } else if (!leftLangLit && !rightLangLit) {
                return Order.incompatibleValueExpression;
            }
        }
        if (literalsEqual) {
            return Order.equal;
        }
        return Order.notEqual;
    }

    private static CoreDatatype.XSD getCommonDatatype(boolean strict, CoreDatatype.XSD leftCoreDatatype, CoreDatatype.XSD rightCoreDatatype) {
        if (leftCoreDatatype != null && rightCoreDatatype != null) {
            if (leftCoreDatatype == rightCoreDatatype) {
                return leftCoreDatatype;
            }
            if (leftCoreDatatype.isNumericDatatype() && rightCoreDatatype.isNumericDatatype()) {
                if (leftCoreDatatype == CoreDatatype.XSD.DOUBLE || rightCoreDatatype == CoreDatatype.XSD.DOUBLE) {
                    return CoreDatatype.XSD.DOUBLE;
                }
                if (leftCoreDatatype == CoreDatatype.XSD.FLOAT || rightCoreDatatype == CoreDatatype.XSD.FLOAT) {
                    return CoreDatatype.XSD.FLOAT;
                }
                if (leftCoreDatatype == CoreDatatype.XSD.DECIMAL || rightCoreDatatype == CoreDatatype.XSD.DECIMAL) {
                    return CoreDatatype.XSD.DECIMAL;
                }
                return CoreDatatype.XSD.INTEGER;
            }
            if (!strict && leftCoreDatatype.isCalendarDatatype() && rightCoreDatatype.isCalendarDatatype()) {
                return CoreDatatype.XSD.DATETIME;
            }
            if (!strict && leftCoreDatatype.isDurationDatatype() && rightCoreDatatype.isDurationDatatype()) {
                return CoreDatatype.XSD.DURATION;
            }
        }
        return null;
    }

    public static boolean isPlainLiteral(Value v) {
        if (v.isLiteral()) {
            return QueryEvaluationUtility.isPlainLiteral((Literal)v);
        }
        return false;
    }

    public static boolean isPlainLiteral(Literal l) {
        assert (l.getLanguage().isEmpty() || l.getCoreDatatype() == CoreDatatype.RDF.LANGSTRING);
        return l.getCoreDatatype() == CoreDatatype.XSD.STRING || l.getCoreDatatype() == CoreDatatype.RDF.LANGSTRING;
    }

    public static boolean isSimpleLiteral(Value v) {
        if (v.isLiteral()) {
            return QueryEvaluationUtility.isSimpleLiteral((Literal)v);
        }
        return false;
    }

    public static boolean isSimpleLiteral(Literal l) {
        return l.getCoreDatatype() == CoreDatatype.XSD.STRING;
    }

    public static boolean isSimpleLiteral(boolean isLang, CoreDatatype datatype) {
        return datatype == CoreDatatype.XSD.STRING;
    }

    public static boolean isStringLiteral(Value v) {
        if (v.isLiteral()) {
            return QueryEvaluationUtility.isStringLiteral((Literal)v);
        }
        return false;
    }

    public static boolean compatibleArguments(Literal arg1, Literal arg2) {
        return QueryEvaluationUtility.isSimpleLiteral(arg1) && QueryEvaluationUtility.isSimpleLiteral(arg2) || Literals.isLanguageLiteral(arg1) && Literals.isLanguageLiteral(arg2) && arg1.getLanguage().equals(arg2.getLanguage()) || Literals.isLanguageLiteral(arg1) && QueryEvaluationUtility.isSimpleLiteral(arg2);
    }

    public static boolean isStringLiteral(Literal l) {
        return l.getCoreDatatype() == CoreDatatype.XSD.STRING || l.getCoreDatatype() == CoreDatatype.RDF.LANGSTRING;
    }

    private static boolean isSupportedDatatype(CoreDatatype.XSD datatype) {
        return datatype != null && (datatype == CoreDatatype.XSD.STRING || datatype.isNumericDatatype() || datatype.isCalendarDatatype());
    }

    public static enum Result {
        _true(true),
        _false(false),
        incompatibleValueExpression,
        illegalArgument;

        private final boolean value;
        private final boolean isIncompatible;

        static Result fromBoolean(boolean b) {
            if (b) {
                return _true;
            }
            return _false;
        }

        private Result(boolean value) {
            this.value = value;
            this.isIncompatible = false;
        }

        private Result() {
            this.isIncompatible = true;
            this.value = false;
        }

        public boolean orElse(boolean alternative) {
            if (this == incompatibleValueExpression) {
                return alternative;
            }
            if (this == illegalArgument) {
                throw new IllegalStateException("IllegalArgument needs to be handled");
            }
            return this.value;
        }
    }

    static enum Order {
        smaller(-1),
        greater(1),
        equal(0),
        notEqual(0),
        incompatibleValueExpression(0),
        illegalArgument(0);

        private final int value;

        private Order(int value) {
            this.value = value;
        }

        public static Order from(int value) {
            if (value < 0) {
                return smaller;
            }
            if (value > 0) {
                return greater;
            }
            return equal;
        }

        public int asInt() {
            if (!this.isValid() && this != notEqual) {
                throw new IllegalStateException();
            }
            return this.value;
        }

        public boolean isValid() {
            return this != incompatibleValueExpression && this != illegalArgument;
        }

        public Result toResult(Compare.CompareOp operator) {
            if (!this.isValid()) {
                if (this == incompatibleValueExpression) {
                    return Result.incompatibleValueExpression;
                }
                if (this == illegalArgument) {
                    return Result.illegalArgument;
                }
            }
            if (this == notEqual) {
                switch (operator) {
                    case EQ: {
                        return Result._false;
                    }
                    case NE: {
                        return Result._true;
                    }
                    case LT: 
                    case LE: 
                    case GE: 
                    case GT: {
                        return Result.incompatibleValueExpression;
                    }
                }
                return Result.illegalArgument;
            }
            switch (operator) {
                case LT: {
                    return Result.fromBoolean(this.value < 0);
                }
                case LE: {
                    return Result.fromBoolean(this.value <= 0);
                }
                case EQ: {
                    return Result.fromBoolean(this.value == 0);
                }
                case NE: {
                    return Result.fromBoolean(this.value != 0);
                }
                case GE: {
                    return Result.fromBoolean(this.value >= 0);
                }
                case GT: {
                    return Result.fromBoolean(this.value > 0);
                }
            }
            return Result.illegalArgument;
        }
    }
}

