/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail.helpers;

import org.eclipse.rdf4j.common.exception.RDF4JException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.repository.util.AbstractRDFInserter;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.UpdateContext;

public class RDFSailInserter
extends AbstractRDFInserter {
    private final SailConnection con;
    private final UpdateContext uc;

    public RDFSailInserter(SailConnection con, ValueFactory vf, UpdateContext uc) {
        super(vf);
        this.con = con;
        this.uc = uc;
    }

    public RDFSailInserter(SailConnection con, ValueFactory vf) {
        this(con, vf, null);
    }

    @Override
    protected void addNamespace(String prefix, String name) throws RDF4JException {
        if (this.con.getNamespace(prefix) == null) {
            this.con.setNamespace(prefix, name);
        }
    }

    @Override
    protected void addStatement(Resource subj, IRI pred, Value obj, Resource ctxt) throws RDF4JException {
        if (this.enforcesContext()) {
            this.addStatement(this.uc, subj, pred, obj, this.contexts);
        } else if (this.uc != null && ctxt == null) {
            IRI insertGraph = this.uc.getDataset().getDefaultInsertGraph();
            if (insertGraph != null) {
                this.addStatement(this.uc, subj, pred, obj, insertGraph);
            } else {
                this.addStatement(this.uc, subj, pred, obj, new Resource[0]);
            }
        } else {
            this.addStatement(this.uc, subj, pred, obj, ctxt);
        }
    }

    private void addStatement(UpdateContext uc, Resource subj, IRI pred, Value obj, Resource ... ctxts) throws SailException {
        if (uc != null) {
            this.con.addStatement(uc, subj, pred, obj, ctxts);
        } else {
            this.con.addStatement(subj, pred, obj, ctxts);
        }
    }
}

