/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LookAheadIteration<E>
extends AbstractCloseableIteration<E> {
    private static final Logger log = LoggerFactory.getLogger(LookAheadIteration.class);
    private E nextElement;

    protected LookAheadIteration() {
    }

    protected abstract E getNextElement();

    @Override
    public final boolean hasNext() {
        if (this.isClosed()) {
            return false;
        }
        try {
            return this.lookAhead() != null;
        }
        catch (NoSuchElementException logged) {
            log.trace("LookAheadIteration threw NoSuchElementException:", (Throwable)logged);
            return false;
        }
    }

    @Override
    public final E next() {
        if (this.isClosed()) {
            throw new NoSuchElementException("The iteration has been closed.");
        }
        E result = this.lookAhead();
        if (result != null) {
            this.nextElement = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    private E lookAhead() {
        if (this.nextElement == null) {
            this.nextElement = this.getNextElement();
            if (this.nextElement == null) {
                this.close();
            }
        }
        return this.nextElement;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

