/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.UpdateExpr;
import org.eclipse.rdf4j.query.parser.ParsedOperation;

public class ParsedUpdate
extends ParsedOperation {
    private final Map<String, String> namespaces;
    private final List<UpdateExpr> updateExprs = new ArrayList<UpdateExpr>();
    private final Map<UpdateExpr, Dataset> datasetMapping = new IdentityHashMap<UpdateExpr, Dataset>();

    public ParsedUpdate() {
        this.namespaces = Map.of();
    }

    public ParsedUpdate(String sourceString) {
        super(sourceString);
        this.namespaces = Map.of();
    }

    public ParsedUpdate(String sourceString, Map<String, String> namespaces) {
        super(sourceString);
        this.namespaces = Objects.requireNonNull(namespaces);
    }

    public ParsedUpdate(Map<String, String> namespaces) {
        this.namespaces = Objects.requireNonNull(namespaces);
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public void addUpdateExpr(UpdateExpr updateExpr) {
        this.updateExprs.add(updateExpr);
    }

    public List<UpdateExpr> getUpdateExprs() {
        return this.updateExprs;
    }

    public void map(UpdateExpr updateExpr, Dataset dataset) {
        this.datasetMapping.put(updateExpr, dataset);
    }

    public Map<UpdateExpr, Dataset> getDatasetMapping() {
        return this.datasetMapping;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (UpdateExpr updateExpr : this.updateExprs) {
            stringBuilder.append(updateExpr.toString());
            stringBuilder.append("; ");
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParsedUpdate that = (ParsedUpdate)o;
        if (!this.namespaces.equals(that.namespaces)) {
            return false;
        }
        if (!this.updateExprs.equals(that.updateExprs)) {
            return false;
        }
        return this.datasetMapping.equals(that.datasetMapping);
    }

    public int hashCode() {
        assert (this.updateExprs.stream().noneMatch(expr -> expr.hashCode() == System.identityHashCode(expr)));
        int result = this.namespaces.hashCode();
        result = 31 * result + this.updateExprs.hashCode();
        result = 31 * result + this.datasetMapping.hashCode();
        return result;
    }
}

