/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.codecs.MutablePointValues;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.PointsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Counter;

class PointValuesWriter {
    private final FieldInfo fieldInfo;
    private final ByteBlockPool bytes;
    private final Counter iwBytesUsed;
    private int[] docIDs;
    private int numPoints;
    private int numDocs;
    private int lastDocID = -1;
    private final int packedBytesLength;

    PointValuesWriter(ByteBlockPool.Allocator allocator, Counter bytesUsed, FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = bytesUsed;
        this.bytes = new ByteBlockPool(allocator);
        this.docIDs = new int[16];
        this.iwBytesUsed.addAndGet(64L);
        this.packedBytesLength = fieldInfo.getPointDimensionCount() * fieldInfo.getPointNumBytes();
    }

    public void addPackedValue(int docID, BytesRef value) {
        if (value == null) {
            throw new IllegalArgumentException("field=" + this.fieldInfo.name + ": point value must not be null");
        }
        if (value.length != this.packedBytesLength) {
            throw new IllegalArgumentException("field=" + this.fieldInfo.name + ": this field's value has length=" + value.length + " but should be " + this.fieldInfo.getPointDimensionCount() * this.fieldInfo.getPointNumBytes());
        }
        if (this.docIDs.length == this.numPoints) {
            this.docIDs = ArrayUtil.grow(this.docIDs, this.numPoints + 1);
            this.iwBytesUsed.addAndGet((this.docIDs.length - this.numPoints) * 4);
        }
        this.bytes.append(value);
        this.docIDs[this.numPoints] = docID;
        if (docID != this.lastDocID) {
            ++this.numDocs;
            this.lastDocID = docID;
        }
        ++this.numPoints;
    }

    public void flush(SegmentWriteState state, Sorter.DocMap sortMap, PointsWriter writer) throws IOException {
        MutablePointValues points = new MutablePointValues(){
            final int[] ords;
            int[] temp;
            {
                this.ords = new int[PointValuesWriter.this.numPoints];
                for (int i = 0; i < PointValuesWriter.this.numPoints; ++i) {
                    this.ords[i] = i;
                }
            }

            @Override
            public void intersect(PointValues.IntersectVisitor visitor) throws IOException {
                BytesRef scratch = new BytesRef();
                byte[] packedValue = new byte[PointValuesWriter.this.packedBytesLength];
                for (int i = 0; i < PointValuesWriter.this.numPoints; ++i) {
                    this.getValue(i, scratch);
                    assert (scratch.length == packedValue.length);
                    System.arraycopy(scratch.bytes, scratch.offset, packedValue, 0, PointValuesWriter.this.packedBytesLength);
                    visitor.visit(this.getDocID(i), packedValue);
                }
            }

            @Override
            public long estimatePointCount(PointValues.IntersectVisitor visitor) {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte[] getMinPackedValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte[] getMaxPackedValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getNumDimensions() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getNumIndexDimensions() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getBytesPerDimension() {
                throw new UnsupportedOperationException();
            }

            @Override
            public long size() {
                return PointValuesWriter.this.numPoints;
            }

            @Override
            public int getDocCount() {
                return PointValuesWriter.this.numDocs;
            }

            @Override
            public void swap(int i, int j) {
                int tmp = this.ords[i];
                this.ords[i] = this.ords[j];
                this.ords[j] = tmp;
            }

            @Override
            public int getDocID(int i) {
                return PointValuesWriter.this.docIDs[this.ords[i]];
            }

            @Override
            public void getValue(int i, BytesRef packedValue) {
                long offset = (long)PointValuesWriter.this.packedBytesLength * (long)this.ords[i];
                packedValue.length = PointValuesWriter.this.packedBytesLength;
                PointValuesWriter.this.bytes.setRawBytesRef(packedValue, offset);
            }

            @Override
            public byte getByteAt(int i, int k) {
                long offset = (long)PointValuesWriter.this.packedBytesLength * (long)this.ords[i] + (long)k;
                return PointValuesWriter.this.bytes.readByte(offset);
            }

            @Override
            public void save(int i, int j) {
                if (this.temp == null) {
                    this.temp = new int[this.ords.length];
                }
                this.temp[j] = this.ords[i];
            }

            @Override
            public void restore(int i, int j) {
                if (this.temp != null) {
                    System.arraycopy(this.temp, i, this.ords, i, j - i);
                }
            }
        };
        final MutablePointValues values = sortMap == null ? points : new MutableSortingPointValues(points, sortMap);
        PointsReader reader = new PointsReader(){

            @Override
            public PointValues getValues(String fieldName) {
                if (!fieldName.equals(((PointValuesWriter)PointValuesWriter.this).fieldInfo.name)) {
                    throw new IllegalArgumentException("fieldName must be the same");
                }
                return values;
            }

            @Override
            public void checkIntegrity() {
                throw new UnsupportedOperationException();
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public void close() {
            }
        };
        writer.writeField(this.fieldInfo, reader);
    }

    static final class MutableSortingPointValues
    extends MutablePointValues {
        private final MutablePointValues in;
        private final Sorter.DocMap docMap;

        public MutableSortingPointValues(MutablePointValues in, Sorter.DocMap docMap) {
            this.in = in;
            this.docMap = docMap;
        }

        @Override
        public void intersect(final PointValues.IntersectVisitor visitor) throws IOException {
            this.in.intersect(new PointValues.IntersectVisitor(){

                @Override
                public void visit(int docID) throws IOException {
                    visitor.visit(docMap.oldToNew(docID));
                }

                @Override
                public void visit(int docID, byte[] packedValue) throws IOException {
                    visitor.visit(docMap.oldToNew(docID), packedValue);
                }

                @Override
                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    return visitor.compare(minPackedValue, maxPackedValue);
                }
            });
        }

        @Override
        public long estimatePointCount(PointValues.IntersectVisitor visitor) {
            return this.in.estimatePointCount(visitor);
        }

        @Override
        public byte[] getMinPackedValue() throws IOException {
            return this.in.getMinPackedValue();
        }

        @Override
        public byte[] getMaxPackedValue() throws IOException {
            return this.in.getMaxPackedValue();
        }

        @Override
        public int getNumDimensions() throws IOException {
            return this.in.getNumDimensions();
        }

        @Override
        public int getNumIndexDimensions() throws IOException {
            return this.in.getNumIndexDimensions();
        }

        @Override
        public int getBytesPerDimension() throws IOException {
            return this.in.getBytesPerDimension();
        }

        @Override
        public long size() {
            return this.in.size();
        }

        @Override
        public int getDocCount() {
            return this.in.getDocCount();
        }

        @Override
        public void getValue(int i, BytesRef packedValue) {
            this.in.getValue(i, packedValue);
        }

        @Override
        public byte getByteAt(int i, int k) {
            return this.in.getByteAt(i, k);
        }

        @Override
        public int getDocID(int i) {
            return this.docMap.oldToNew(this.in.getDocID(i));
        }

        @Override
        public void swap(int i, int j) {
            this.in.swap(i, j);
        }

        @Override
        public void save(int i, int j) {
            this.in.save(i, j);
        }

        @Override
        public void restore(int i, int j) {
            this.in.restore(i, j);
        }
    }
}

