/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.metadata;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;

public class PropertyMetadata {
    private String m_name;
    private String m_type;
    private Object m_value;
    private boolean m_validated = false;

    public void setName(String name) {
        if (this.m_validated) {
            return;
        }
        this.m_name = name;
    }

    public void setType(String type) {
        if (this.m_validated) {
            return;
        }
        this.m_type = type;
    }

    public void setValue(String value) {
        if (this.m_validated) {
            return;
        }
        this.m_value = value;
    }

    public void setValues(String values) {
        if (this.m_validated) {
            return;
        }
        ArrayList<String> valueList = new ArrayList<String>();
        StringTokenizer tokener = new StringTokenizer(values, "\r\n");
        while (tokener.hasMoreTokens()) {
            String value = tokener.nextToken().trim();
            if (value.length() <= 0) continue;
            valueList.add(value);
        }
        this.m_value = valueList.toArray(new String[valueList.size()]);
    }

    public String getName() {
        return this.m_name;
    }

    public String getType() {
        return this.m_type;
    }

    public Object getValue() {
        return this.m_value;
    }

    public void validate(ComponentMetadata componentMetadata) {
        if (this.m_name == null) {
            throw componentMetadata.validationFailure("Property name attribute is mandatory");
        }
        if (this.m_type == null) {
            this.m_type = "String";
        } else {
            if (componentMetadata.getDSVersion().isDS11() && this.m_type.equals("Char")) {
                throw componentMetadata.validationFailure("Illegal property type 'Char' used for DS 1.1 descriptor, use 'Character' instead");
            }
            if (!componentMetadata.getDSVersion().isDS11() && this.m_type.equals("Character")) {
                throw componentMetadata.validationFailure("Illegal property type 'Character' used for DS 1.0 descriptor, use 'Char' instead");
            }
        }
        if (this.m_value != null) {
            try {
                this.m_value = this.m_value instanceof String ? this.toType((String)this.m_value) : this.toTypeArray((String[])this.m_value);
            }
            catch (NumberFormatException nfe) {
                throw componentMetadata.validationFailure(this.getName() + ": Cannot convert property value to " + this.getType());
            }
            catch (IllegalArgumentException e) {
                throw componentMetadata.validationFailure(this.getName() + ": " + e.getMessage());
            }
        }
        this.m_validated = true;
    }

    private Object toType(String value) {
        if (this.m_type.equals("String")) {
            return value;
        }
        if (this.m_type.equals("Long")) {
            return Long.valueOf(value);
        }
        if (this.m_type.equals("Double")) {
            return Double.valueOf(value);
        }
        if (this.m_type.equals("Float")) {
            return Float.valueOf(value);
        }
        if (this.m_type.equals("Integer")) {
            return Integer.valueOf(value);
        }
        if (this.m_type.equals("Byte")) {
            return Byte.valueOf(value);
        }
        if (this.m_type.equals("Char") || this.m_type.equals("Character")) {
            return Character.valueOf((char)Integer.parseInt(value));
        }
        if (this.m_type.equals("Boolean")) {
            return Boolean.valueOf(value);
        }
        if (this.m_type.equals("Short")) {
            return Short.valueOf(value);
        }
        throw new IllegalArgumentException("Undefined property type '" + this.m_type + "'");
    }

    private Object toTypeArray(String[] valueList) {
        if (this.m_type.equals("String")) {
            return valueList;
        }
        if (this.m_type.equals("Double")) {
            double[] array = new double[valueList.length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = Double.parseDouble(valueList[i]);
            }
            return array;
        }
        if (this.m_type.equals("Float")) {
            float[] array = new float[valueList.length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = Float.parseFloat(valueList[i]);
            }
            return array;
        }
        if (this.m_type.equals("Long")) {
            long[] array = new long[valueList.length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = Long.parseLong(valueList[i]);
            }
            return array;
        }
        if (this.m_type.equals("Integer")) {
            int[] array = new int[valueList.length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = Integer.parseInt(valueList[i]);
            }
            return array;
        }
        if (this.m_type.equals("Short")) {
            short[] array = new short[valueList.length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = Short.parseShort(valueList[i]);
            }
            return array;
        }
        if (this.m_type.equals("Byte")) {
            byte[] array = new byte[valueList.length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = Byte.parseByte(valueList[i]);
            }
            return array;
        }
        if (this.m_type.equals("Char") || this.m_type.equals("Character")) {
            char[] array = new char[valueList.length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (char)Integer.parseInt(valueList[i]);
            }
            return array;
        }
        if (this.m_type.equals("Boolean")) {
            boolean[] array = new boolean[valueList.length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = Boolean.valueOf(valueList[i]);
            }
            return array;
        }
        throw new IllegalArgumentException("Undefined property type '" + this.m_type + "'");
    }
}

