/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal.gridcolumnkit;

import java.io.IOException;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridColumnGroup;
import org.eclipse.nebula.widgets.grid.internal.IGridAdapter;
import org.eclipse.nebula.widgets.grid.internal.gridcolumnkit.GridColumnOperationHandler;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.JsonMapping;
import org.eclipse.rap.rwt.remote.OperationHandler;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.rap.rwt.theme.ControlThemeAdapter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class GridColumnLCA
extends WidgetLCA<GridColumn> {
    public static final GridColumnLCA INSTANCE = new GridColumnLCA();
    private static final String TYPE = "rwt.widgets.GridColumn";
    private static final String PROP_INDEX = "index";
    private static final String PROP_LEFT = "left";
    private static final String PROP_WIDTH = "width";
    private static final String PROP_ALIGNMENT = "alignment";
    private static final String PROP_RESIZABLE = "resizable";
    private static final String PROP_MOVEABLE = "moveable";
    private static final String PROP_VISIBLE = "visibility";
    private static final String PROP_CHECK = "check";
    private static final String PROP_FONT = "font";
    private static final String PROP_FOOTER_FONT = "footerFont";
    private static final String PROP_FOOTER_TEXT = "footerText";
    private static final String PROP_FOOTER_IMAGE = "footerImage";
    private static final String PROP_FOOTER_SPAN = "footerSpan";
    private static final String PROP_WORD_WRAP = "wordWrap";
    private static final String PROP_HEADER_WORD_WRAP = "headerWordWrap";
    private static final int ZERO = 0;
    private static final String DEFAULT_ALIGNMENT = "left";

    public void renderInitialization(GridColumn column) throws IOException {
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject((Widget)column, (String)TYPE);
        remoteObject.setHandler((OperationHandler)new GridColumnOperationHandler(column));
        remoteObject.set("parent", WidgetUtil.getId((Widget)column.getParent()));
        GridColumnGroup group = column.getColumnGroup();
        if (group != null) {
            remoteObject.set("group", WidgetUtil.getId((Widget)group));
        }
    }

    public void preserveValues(GridColumn column) {
        WidgetLCAUtil.preserveToolTipText((Widget)column, (String)column.getHeaderTooltip());
        ItemLCAUtil.preserve((Item)column);
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_INDEX, (int)GridColumnLCA.getIndex(column));
        WidgetLCAUtil.preserveProperty((Widget)column, (String)"left", (int)GridColumnLCA.getLeft(column));
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_WIDTH, (int)column.getWidth());
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_ALIGNMENT, (Object)GridColumnLCA.getAlignment(column));
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_RESIZABLE, (boolean)column.getResizeable());
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_MOVEABLE, (boolean)column.getMoveable());
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_VISIBLE, (boolean)column.isVisible());
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_CHECK, (boolean)column.isCheck());
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_FONT, (Object)column.getHeaderFont());
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_FOOTER_FONT, (Object)column.getFooterFont());
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_FOOTER_TEXT, (Object)column.getFooterText());
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_FOOTER_IMAGE, (Object)column.getFooterImage());
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_FOOTER_SPAN, (int)GridColumnLCA.getFooterSpan(column));
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_WORD_WRAP, (boolean)column.getWordWrap());
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_HEADER_WORD_WRAP, (boolean)column.getHeaderWordWrap());
    }

    public void renderChanges(GridColumn column) throws IOException {
        WidgetLCAUtil.renderToolTip((Widget)column, (String)column.getHeaderTooltip());
        WidgetLCAUtil.renderCustomVariant((Widget)column);
        ItemLCAUtil.renderChanges((Item)column);
        WidgetLCAUtil.renderProperty((Widget)column, (String)PROP_INDEX, (int)GridColumnLCA.getIndex(column), (int)-1);
        WidgetLCAUtil.renderProperty((Widget)column, (String)"left", (int)GridColumnLCA.getLeft(column), (int)0);
        WidgetLCAUtil.renderProperty((Widget)column, (String)PROP_WIDTH, (int)column.getWidth(), (int)0);
        WidgetLCAUtil.renderProperty((Widget)column, (String)PROP_ALIGNMENT, (String)GridColumnLCA.getAlignment(column), (String)"left");
        WidgetLCAUtil.renderProperty((Widget)column, (String)PROP_RESIZABLE, (boolean)column.getResizeable(), (boolean)true);
        WidgetLCAUtil.renderProperty((Widget)column, (String)PROP_MOVEABLE, (boolean)column.getMoveable(), (boolean)false);
        WidgetLCAUtil.renderProperty((Widget)column, (String)PROP_VISIBLE, (boolean)column.isVisible(), (boolean)true);
        WidgetLCAUtil.renderProperty((Widget)column, (String)PROP_CHECK, (boolean)column.isCheck(), (boolean)false);
        GridColumnLCA.renderFont(column, PROP_FONT, column.getHeaderFont());
        GridColumnLCA.renderFont(column, PROP_FOOTER_FONT, column.getFooterFont());
        WidgetLCAUtil.renderProperty((Widget)column, (String)PROP_FOOTER_TEXT, (String)column.getFooterText(), (String)"");
        WidgetLCAUtil.renderProperty((Widget)column, (String)PROP_FOOTER_IMAGE, (Image)column.getFooterImage(), null);
        WidgetLCAUtil.renderProperty((Widget)column, (String)PROP_FOOTER_SPAN, (int)GridColumnLCA.getFooterSpan(column), (int)1);
        WidgetLCAUtil.renderProperty((Widget)column, (String)PROP_WORD_WRAP, (boolean)column.getWordWrap(), (boolean)false);
        WidgetLCAUtil.renderProperty((Widget)column, (String)PROP_HEADER_WORD_WRAP, (boolean)column.getHeaderWordWrap(), (boolean)false);
        WidgetLCAUtil.renderListenSelection((Widget)column);
    }

    private static void renderFont(GridColumn column, String property, Font newValue) {
        Grid grid = column.getParent();
        Font defaultFont = grid.getAdapter(ControlThemeAdapter.class).getFont((Control)grid);
        if (WidgetLCAUtil.hasChanged((Widget)column, (String)property, (Object)newValue, (Object)defaultFont)) {
            RemoteObjectFactory.getRemoteObject((Widget)column).set(property, JsonMapping.toJson((Font)newValue));
        }
    }

    private static int getLeft(GridColumn column) {
        return GridColumnLCA.getGridAdapter(column).getCellLeft(GridColumnLCA.getIndex(column));
    }

    private static String getAlignment(GridColumn column) {
        int alignment = column.getAlignment();
        String result = "left";
        if ((alignment & 0x1000000) != 0) {
            result = "center";
        } else if ((alignment & 0x20000) != 0) {
            result = "right";
        }
        return result;
    }

    private static int getIndex(GridColumn column) {
        return column.getParent().indexOf(column);
    }

    private static int getFooterSpan(GridColumn column) {
        Integer value = (Integer)column.getData(PROP_FOOTER_SPAN);
        return value == null ? 1 : value;
    }

    private static IGridAdapter getGridAdapter(GridColumn column) {
        return column.getParent().getAdapter(IGridAdapter.class);
    }
}

