/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.spinnerkit;

import java.io.IOException;
import java.text.DecimalFormatSymbols;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.internal.widgets.spinnerkit.SpinnerOperationHandler;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public final class SpinnerLCA
extends WidgetLCA<Spinner> {
    public static final SpinnerLCA INSTANCE = new SpinnerLCA();
    private static final String TYPE = "rwt.widgets.Spinner";
    private static final String[] ALLOWED_STYLES = new String[]{"READ_ONLY", "WRAP", "BORDER"};
    static final String PROP_MINIMUM = "minimum";
    static final String PROP_MAXIMUM = "maximum";
    static final String PROP_SELECTION = "selection";
    static final String PROP_DIGITS = "digits";
    static final String PROP_INCREMENT = "increment";
    static final String PROP_PAGE_INCREMENT = "pageIncrement";
    static final String PROP_TEXT_LIMIT = "textLimit";
    static final String PROP_DECIMAL_SEPARATOR = "decimalSeparator";
    static final String PROP_SELECTION_LISTENER = "Selection";
    static final String PROP_DEFAULT_SELECTION_LISTENER = "DefaultSelection";
    private static final int DEFAULT_MINIMUM = 0;
    private static final int DEFAULT_MAXIMUM = 100;
    private static final int DEFAULT_SELECTION = 0;
    private static final int DEFAULT_DIGITS = 0;
    private static final int DEFAULT_INCREMENT = 1;
    private static final int DEFAULT_PAGE_INCREMENT = 10;
    private static final String DEFAULT_DECIMAL_SEPARATOR = ".";

    @Override
    public void preserveValues(Spinner spinner) {
        WidgetLCAUtil.preserveProperty((Widget)spinner, PROP_MINIMUM, spinner.getMinimum());
        WidgetLCAUtil.preserveProperty((Widget)spinner, PROP_MAXIMUM, spinner.getMaximum());
        WidgetLCAUtil.preserveProperty((Widget)spinner, PROP_SELECTION, spinner.getSelection());
        WidgetLCAUtil.preserveProperty((Widget)spinner, PROP_DIGITS, spinner.getDigits());
        WidgetLCAUtil.preserveProperty((Widget)spinner, PROP_INCREMENT, spinner.getIncrement());
        WidgetLCAUtil.preserveProperty((Widget)spinner, PROP_PAGE_INCREMENT, spinner.getPageIncrement());
        WidgetLCAUtil.preserveProperty((Widget)spinner, PROP_TEXT_LIMIT, SpinnerLCA.getTextLimit(spinner));
        WidgetLCAUtil.preserveProperty((Widget)spinner, PROP_DECIMAL_SEPARATOR, SpinnerLCA.getDecimalSeparator());
    }

    @Override
    public void renderInitialization(Spinner spinner) throws IOException {
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(spinner, TYPE);
        remoteObject.setHandler(new SpinnerOperationHandler(spinner));
        remoteObject.set("parent", WidgetUtil.getId(spinner.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(spinner, ALLOWED_STYLES)));
    }

    @Override
    public void renderChanges(Spinner spinner) throws IOException {
        ControlLCAUtil.renderChanges(spinner);
        WidgetLCAUtil.renderCustomVariant(spinner);
        SpinnerLCA.renderMinimum(spinner);
        SpinnerLCA.renderMaximum(spinner);
        SpinnerLCA.renderSelection(spinner);
        SpinnerLCA.renderDigits(spinner);
        SpinnerLCA.renderIncrement(spinner);
        SpinnerLCA.renderPageIncrement(spinner);
        SpinnerLCA.renderTextLimit(spinner);
        SpinnerLCA.renderDecimalSeparator(spinner);
        WidgetLCAUtil.renderListenModifyVerify(spinner);
        SpinnerLCA.renderListenSelection(spinner);
        WidgetLCAUtil.renderClientListeners(spinner);
    }

    private static void renderMinimum(Spinner spinner) {
        WidgetLCAUtil.renderProperty((Widget)spinner, PROP_MINIMUM, spinner.getMinimum(), 0);
    }

    private static void renderMaximum(Spinner spinner) {
        WidgetLCAUtil.renderProperty((Widget)spinner, PROP_MAXIMUM, spinner.getMaximum(), 100);
    }

    private static void renderSelection(Spinner spinner) {
        WidgetLCAUtil.renderProperty((Widget)spinner, PROP_SELECTION, spinner.getSelection(), 0);
    }

    private static void renderDigits(Spinner spinner) {
        WidgetLCAUtil.renderProperty((Widget)spinner, PROP_DIGITS, spinner.getDigits(), 0);
    }

    private static void renderIncrement(Spinner spinner) {
        WidgetLCAUtil.renderProperty((Widget)spinner, PROP_INCREMENT, spinner.getIncrement(), 1);
    }

    private static void renderPageIncrement(Spinner spinner) {
        int defValue = 10;
        WidgetLCAUtil.renderProperty((Widget)spinner, PROP_PAGE_INCREMENT, spinner.getPageIncrement(), defValue);
    }

    private static void renderTextLimit(Spinner spinner) {
        WidgetLCAUtil.renderProperty((Widget)spinner, PROP_TEXT_LIMIT, SpinnerLCA.getTextLimit(spinner), null);
    }

    private static void renderDecimalSeparator(Spinner spinner) {
        String defValue = DEFAULT_DECIMAL_SEPARATOR;
        WidgetLCAUtil.renderProperty((Widget)spinner, PROP_DECIMAL_SEPARATOR, SpinnerLCA.getDecimalSeparator(), defValue);
    }

    private static void renderListenSelection(Spinner spinner) {
        WidgetLCAUtil.renderListener(spinner, 13, PROP_SELECTION_LISTENER);
        WidgetLCAUtil.renderListener(spinner, 14, PROP_DEFAULT_SELECTION_LISTENER);
    }

    private static Integer getTextLimit(Spinner spinner) {
        Integer result = null;
        int textLimit = spinner.getTextLimit();
        if (textLimit > 0 && textLimit != Integer.MAX_VALUE) {
            result = textLimit;
        }
        return result;
    }

    private static String getDecimalSeparator() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(RWT.getLocale());
        return String.valueOf(symbols.getDecimalSeparator());
    }

    private SpinnerLCA() {
    }
}

