/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.tools.intro.internal.target;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rap.tools.intro.internal.ErrorUtil;
import org.eclipse.rap.tools.intro.internal.target.InstallTargetDialog;
import org.eclipse.rap.tools.intro.internal.target.IntroMessages;
import org.eclipse.rap.tools.intro.internal.target.TargetProvider;
import org.eclipse.rap.tools.intro.internal.target.TargetSwitcher;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class InstallRAPTargetHandler
extends AbstractHandler {
    private static final ISchedulingRule INSTALL_RULE = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    };

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbench workbench;
        Shell shell;
        InstallTargetDialog dialog;
        int result;
        Object trigger = event.getTrigger();
        String targetDefinitionURI = TargetProvider.TARGET_REPOSITORY;
        if (trigger instanceof Event && "e4".equals(((Event)trigger).text)) {
            targetDefinitionURI = TargetProvider.TARGET_E4_REPOSITORY;
        }
        if ((result = (dialog = new InstallTargetDialog(shell = (workbench = PlatformUI.getWorkbench()).getActiveWorkbenchWindow().getShell())).open()) == 0) {
            InstallRAPTargetHandler.execute(dialog.shouldSwitchTarget(), targetDefinitionURI);
        }
        return null;
    }

    public static void execute(final boolean switchTarget, final String targetDefinitionURI) {
        Job installTargetJob = new Job(IntroMessages.TargetProvider_Installing){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = Status.CANCEL_STATUS;
                try {
                    TargetSwitcher.install(targetDefinitionURI, switchTarget, monitor);
                    result = Status.OK_STATUS;
                }
                catch (CoreException e) {
                    String msg = IntroMessages.InstallRAPTargetHandler_InstallFailed;
                    result = ErrorUtil.createErrorStatus(msg, e);
                }
                return result;
            }
        };
        installTargetJob.setUser(true);
        installTargetJob.setRule(INSTALL_RULE);
        installTargetJob.schedule();
    }
}

