/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;

public class PixelConverter {
    private static final double FONT_WS_FACTOR;
    private final FontMetrics fFontMetrics;
    private final boolean fMonospace;

    static {
        String ws = Platform.getWS();
        FONT_WS_FACTOR = ws.equals("win32") ? 0.95 : (ws.equals("gtk") ? 1.15 : 1.0);
    }

    public PixelConverter(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        this.fFontMetrics = gc.getFontMetrics();
        this.fMonospace = gc.stringExtent((String)"i").x == gc.stringExtent((String)"W").x;
        gc.dispose();
    }

    public int convertHeightInCharsToPixels(int chars) {
        return Dialog.convertHeightInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
    }

    public int convertHorizontalDLUsToPixels(int dlus) {
        return Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fFontMetrics, (int)dlus);
    }

    public int convertVerticalDLUsToPixels(int dlus) {
        return Dialog.convertVerticalDLUsToPixels((FontMetrics)this.fFontMetrics, (int)dlus);
    }

    public int convertWidthInCharsToPixels(int chars) {
        if (this.fMonospace) {
            return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
        }
        return (int)(FONT_WS_FACTOR * (double)Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars));
    }
}

