/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.workbench.search.ui;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.search.ui.text.Match;
import org.eclipse.statet.ecommons.workbench.search.ui.ElementMatchComparator;
import org.eclipse.statet.ecommons.workbench.search.ui.ExtTextSearchResult;
import org.eclipse.statet.ecommons.workbench.search.ui.ExtTextSearchResultPage;
import org.eclipse.statet.ecommons.workbench.search.ui.TextSearchResultContentProvider;
import org.eclipse.statet.jcommons.collections.SortedArraySet;

public class TextSearchResultTableContentProvider<E, M extends Match>
extends TextSearchResultContentProvider<E, M, TableViewer> {
    protected final ElementMatchComparator<E, M> comparator;
    private final SortedArraySet<E> currentElements;

    public TextSearchResultTableContentProvider(ExtTextSearchResultPage<E, M> page, TableViewer viewer) {
        super(page, viewer);
        this.comparator = page.comparator;
        this.currentElements = new SortedArraySet((Object[])this.comparator.getElement0(), this.comparator.getElementComparator());
    }

    @Override
    protected void reset() {
        super.reset();
        this.currentElements.clear();
    }

    public Object[] getElements(Object inputElement) {
        if (!this.active) {
            int limit;
            ExtTextSearchResult result = this.getInput();
            assert (result == inputElement);
            if (result == null) {
                return NO_ELEMENTS;
            }
            assert (this.currentElements.isEmpty());
            Object[] elements = result.getElements();
            if (elements.length <= (limit = this.getElementLimit()) && result.getActiveMatchFilters() == null) {
                this.currentElements.addAll((Collection)new SortedArraySet(elements, result.getComparator().getElementComparator()));
                this.active = true;
                return elements;
            }
            int i = 0;
            while (i < elements.length && this.currentElements.size() < limit) {
                if (result.hasPickedMatches(elements[i])) {
                    this.currentElements.addE(this.currentElements.size(), elements[i]);
                }
                ++i;
            }
            this.active = true;
        }
        return this.currentElements.toArray();
    }

    @Override
    public void elementsChanged(Object[] elements) {
        if (!this.active) {
            return;
        }
        ExtTextSearchResult result = this.getInput();
        int limit = this.getElementLimit();
        TableViewer viewer = (TableViewer)this.getViewer();
        viewer.getTable().setRedraw(false);
        try {
            ArrayList<Object> toUpdate = new ArrayList<Object>();
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                if (result.hasPickedMatches(element)) {
                    if (this.currentElements.size() < limit) {
                        idx = this.currentElements.addE(element);
                        if (idx >= 0) {
                            viewer.insert(element, idx);
                        } else {
                            toUpdate.add(element);
                        }
                    } else if (this.currentElements.contains(element)) {
                        toUpdate.add(element);
                    }
                } else {
                    idx = this.currentElements.removeE(element);
                    if (idx >= 0) {
                        viewer.remove(element);
                    }
                }
                ++i;
            }
            viewer.refresh((Object)toUpdate.toArray(), true);
        }
        finally {
            viewer.getTable().setRedraw(true);
        }
    }
}

