/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.collections;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.eclipse.statet.internal.jcommons.collections.AbstractImIntList;
import org.eclipse.statet.internal.jcommons.collections.ArrayUtils;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.collections.IntListIterator;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ImIntArrayList
extends AbstractImIntList {
    private final int[] array;

    public ImIntArrayList(int[] array) {
        this.array = array;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(int e) {
        return this.indexOf(e) >= 0;
    }

    @Override
    public int getAt(int index) {
        if (index < 0 || index >= this.array.length) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return this.array[index];
    }

    @Override
    public int getFirst() {
        return this.array[0];
    }

    @Override
    public int getLast() {
        return this.array[this.array.length - 1];
    }

    @Override
    public int indexOf(int e) {
        int i = 0;
        while (i < this.array.length) {
            if (this.array[i] == e) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int e) {
        int i = this.array.length - 1;
        while (i >= 0) {
            if (this.array[i] == e) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public IntListIterator iterator() {
        return new Iter(0);
    }

    @Override
    public IntListIterator listIterator(int index) {
        if (index < 0 || index > this.array.length) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return new Iter(index);
    }

    @Override
    public IntStream stream() {
        return StreamSupport.intStream(Spliterators.spliterator(this.array, 1040), false);
    }

    @Override
    public int[] toArray() {
        return Arrays.copyOf(this.array, this.array.length);
    }

    @Override
    public void toArray(int[] array) {
        System.arraycopy(this.array, 0, array, 0, this.array.length);
    }

    @Override
    public void copyTo(int srcIndex, int[] dest, int destIndex, int length) {
        System.arraycopy(this.array, srcIndex, dest, destIndex, length);
    }

    @Override
    public void copyTo(int[] dest, int destIndex) {
        System.arraycopy(this.array, 0, dest, destIndex, this.array.length);
    }

    @Override
    public String getString() {
        return new String(this.array, 0, this.array.length);
    }

    public int hashCode() {
        int hashCode = 9;
        int i = 0;
        while (i < this.array.length) {
            hashCode = 31 * hashCode + this.array[i];
            ++i;
        }
        return hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IntList) {
            IntList other = (IntList)obj;
            if (this.array.length != other.size()) {
                return false;
            }
            int i = 0;
            while (i < this.array.length) {
                if (this.array[i] != other.getAt(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return ArrayUtils.toString(this.array, 0, this.array.length);
    }

    private class Iter
    extends AbstractImIntList.AbstractImIntListIter {
        private int cursor;

        Iter(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < ImIntArrayList.this.array.length;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int nextInt() {
            if (this.cursor >= ImIntArrayList.this.array.length) {
                throw new NoSuchElementException();
            }
            return ImIntArrayList.this.array[this.cursor++];
        }

        @Override
        public Integer next() {
            if (this.cursor >= ImIntArrayList.this.array.length) {
                throw new NoSuchElementException();
            }
            return ImIntArrayList.this.array[this.cursor++];
        }

        @Override
        public int nextIntElse(int elseInt) {
            if (this.cursor >= ImIntArrayList.this.array.length) {
                return elseInt;
            }
            return ImIntArrayList.this.array[this.cursor++];
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public int previousInt() {
            if (this.cursor <= 0) {
                throw new NoSuchElementException();
            }
            return ImIntArrayList.this.array[--this.cursor];
        }

        @Override
        public Integer previous() {
            if (this.cursor <= 0) {
                throw new NoSuchElementException();
            }
            return ImIntArrayList.this.array[--this.cursor];
        }
    }
}

