/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.IntFunction;
import org.eclipse.statet.internal.jcommons.collections.ArrayUtils;
import org.eclipse.statet.jcommons.collections.AbstractImCollection;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class BasicEmptyImCollection<E>
extends AbstractImCollection<E>
implements RandomAccess {
    private final ListIterator<E> iterator = new AbstractImCollection.AbstractImListIter<E>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public E previous() {
            throw new NoSuchElementException();
        }
    };

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean contains(@Nullable Object e) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return c.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.iterator;
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.emptySpliterator();
    }

    @Override
    public Object[] toArray() {
        return ArrayUtils.EMPTY_OBJ;
    }

    @Override
    public <T> T[] toArray(T[] dest) {
        if (dest.length > 0) {
            dest[0] = null;
        }
        return dest;
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        return generator.apply(0);
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof List) {
            List other = (List)obj;
            return other.isEmpty();
        }
        return false;
    }

    public String toString() {
        return "[]";
    }
}

