/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.actions.AbstractSourceEditorHandler;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.QuickAssistProcessorCommandExtension;
import org.eclipse.swt.graphics.Point;

@NonNullByDefault
public class QuickAssistCommandHandler
extends AbstractSourceEditorHandler
implements IExecutableExtension {
    private String commandId;

    public QuickAssistCommandHandler(String commandId) {
        this.commandId = commandId;
    }

    public QuickAssistCommandHandler() {
        this.commandId = (String)ObjectUtils.nonNullLateInit();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, @Nullable Object data) throws CoreException {
        if (ObjectUtils.isNull((Object)this.commandId)) {
            this.commandId = ((String)ObjectUtils.nonNullAssert((Object)config.getAttribute("commandId"))).intern();
        }
    }

    @Override
    protected boolean isEditAction() {
        return true;
    }

    @Override
    protected @Nullable Object execute(SourceEditor editor, ExecutionEvent event) throws ExecutionException {
        QuickAssistProcessorCommandExtension processor = this.getProcessor(editor);
        if (processor == null) {
            return ACTION_NOT_AVAILABLE;
        }
        IDocument document = (IDocument)ObjectUtils.nonNullAssert((Object)editor.getViewer().getDocument());
        IQuickAssistInvocationContext invocationContext = editor.getViewer().getQuickAssistInvocationContext();
        AssistProposal proposal = processor.findQuickAssist(invocationContext, this.commandId);
        if (proposal == null) {
            return ACTION_NOT_AVAILABLE;
        }
        if (this.isEditAction() && !editor.isEditable(true)) {
            return DOCUMENT_NOT_EDITABLE;
        }
        proposal.apply((ITextViewer)editor.getViewer(), '\u0000', 0, invocationContext.getOffset());
        Point selection = proposal.getSelection(document);
        if (selection != null) {
            editor.selectAndReveal(selection.x, selection.y);
        }
        return null;
    }

    private @Nullable QuickAssistProcessorCommandExtension getProcessor(SourceEditor editor) {
        IQuickAssistProcessor processor;
        IQuickAssistAssistant assistant = editor.getViewer().getQuickAssistAssistant();
        if (assistant != null && (processor = assistant.getQuickAssistProcessor()) instanceof QuickAssistProcessorCommandExtension) {
            return (QuickAssistProcessorCommandExtension)processor;
        }
        return null;
    }
}

