/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.IgnoreFilter;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.CurrentOfNode;
import org.apache.derby.impl.sql.compile.CurrentRowLocationNode;
import org.apache.derby.impl.sql.compile.DMLModStatementNode;
import org.apache.derby.impl.sql.compile.DefaultNode;
import org.apache.derby.impl.sql.compile.DeleteNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.HalfOuterJoinNode;
import org.apache.derby.impl.sql.compile.InsertNode;
import org.apache.derby.impl.sql.compile.MergeNode;
import org.apache.derby.impl.sql.compile.NumericConstantNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.SubqueryNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.UpdateNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

public class MatchingClauseNode
extends QueryTreeNode {
    private static final String CURRENT_OF_NODE_NAME = "$MERGE_CURRENT";
    private ValueNode _matchingRefinement;
    private ResultColumnList _updateColumns;
    private ResultColumnList _insertColumns;
    private ResultColumnList _insertValues;
    private DMLModStatementNode _dml;
    private ResultColumnList _thenColumns;
    private int _clauseNumber;
    private String _actionMethodName;
    private String _resultSetFieldName;
    private String _rowMakingMethodName;

    private MatchingClauseNode(ValueNode valueNode, ResultColumnList resultColumnList, ResultColumnList resultColumnList2, ResultColumnList resultColumnList3, ContextManager contextManager) throws StandardException {
        super(contextManager);
        this._matchingRefinement = valueNode;
        this._updateColumns = resultColumnList;
        this._insertColumns = resultColumnList2;
        this._insertValues = resultColumnList3;
    }

    static MatchingClauseNode makeUpdateClause(ValueNode valueNode, ResultColumnList resultColumnList, ContextManager contextManager) throws StandardException {
        return new MatchingClauseNode(valueNode, resultColumnList, null, null, contextManager);
    }

    static MatchingClauseNode makeDeleteClause(ValueNode valueNode, ContextManager contextManager) throws StandardException {
        return new MatchingClauseNode(valueNode, null, null, null, contextManager);
    }

    static MatchingClauseNode makeInsertClause(ValueNode valueNode, ResultColumnList resultColumnList, ResultColumnList resultColumnList2, ContextManager contextManager) throws StandardException {
        return new MatchingClauseNode(valueNode, null, resultColumnList, resultColumnList2, contextManager);
    }

    boolean isUpdateClause() {
        return this._updateColumns != null;
    }

    boolean isInsertClause() {
        return this._insertValues != null;
    }

    boolean isDeleteClause() {
        return !this.isUpdateClause() && !this.isInsertClause();
    }

    ResultColumnList getThenColumns() {
        return this._thenColumns;
    }

    void bind(DataDictionary dataDictionary, MergeNode mergeNode, FromList fromList, FromBaseTable fromBaseTable) throws StandardException {
        this.forbidSubqueries();
        this._thenColumns = new ResultColumnList(this.getContextManager());
        if (this.isDeleteClause()) {
            this.bindDelete(dataDictionary, fromList, fromBaseTable);
        }
        if (this.isUpdateClause()) {
            this.bindUpdate(dataDictionary, mergeNode, fromList, fromBaseTable);
        }
        if (this.isInsertClause()) {
            this.bindInsert(dataDictionary, mergeNode, fromList, fromBaseTable);
        }
    }

    void bindRefinement(MergeNode mergeNode, FromList fromList) throws StandardException {
        if (this._matchingRefinement != null) {
            FromList fromList2 = fromList;
            if (this.isInsertClause()) {
                fromList2 = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
                fromList2.addElement(fromList.elementAt(0));
            }
            mergeNode.bindExpression(this._matchingRefinement, fromList2);
        }
    }

    void getColumnsInExpressions(MergeNode mergeNode, HashMap<String, ColumnReference> hashMap) throws StandardException {
        if (this._matchingRefinement != null) {
            mergeNode.getColumnsInExpression(hashMap, this._matchingRefinement, 0);
        }
        if (this.isUpdateClause()) {
            TableName tableName = mergeNode.getTargetTable().getTableName();
            for (ResultColumn resultColumn : this._updateColumns) {
                mergeNode.getColumnsInExpression(hashMap, resultColumn.getExpression(), 0);
                ColumnReference columnReference = new ColumnReference(resultColumn.getName(), tableName, this.getContextManager());
                mergeNode.addColumn(hashMap, columnReference, 2);
            }
        } else if (this.isInsertClause()) {
            for (ResultColumn resultColumn : this._insertValues) {
                mergeNode.getColumnsInExpression(hashMap, resultColumn.getExpression(), 0);
            }
        } else if (this.isDeleteClause()) {
            mergeNode.getColumnsFromList(hashMap, this._thenColumns, 2);
        }
    }

    private void bindUpdate(DataDictionary dataDictionary, MergeNode mergeNode, FromList fromList, FromBaseTable fromBaseTable) throws StandardException {
        ResultColumnList resultColumnList = this.realiasSetClauses(fromBaseTable);
        this.bindSetClauses(mergeNode, fromList, fromBaseTable, resultColumnList);
        TableName tableName = fromBaseTable.getTableNameField();
        FromList fromList2 = fromList;
        SelectNode selectNode = new SelectNode(resultColumnList, fromList2, null, null, null, null, null, this.getContextManager());
        this._dml = new UpdateNode(tableName, selectNode, this, this.getContextManager());
        this._dml.bindStatement();
        boolean bl = this.getCompilerContext().skipTypePrivileges(true);
        ResultColumnList resultColumnList2 = new ResultColumnList(this.getContextManager());
        ResultColumnList resultColumnList3 = new ResultColumnList(this.getContextManager());
        ResultColumnList resultColumnList4 = this.getBoundSelectUnderUpdate().getResultColumns();
        int n = resultColumnList4.size() / 2;
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList4.elementAt(i);
            ResultColumn resultColumn2 = (ResultColumn)resultColumnList4.elementAt(i + n);
            ResultColumn resultColumn3 = resultColumn.cloneMe();
            ResultColumn resultColumn4 = resultColumn2.cloneMe();
            resultColumnList2.addResultColumn(resultColumn3);
            resultColumnList3.addResultColumn(resultColumn4);
        }
        this.buildThenColumnsForUpdate(fromList, fromBaseTable, resultColumnList4, resultColumnList2, resultColumnList3);
        this.getCompilerContext().skipTypePrivileges(bl);
    }

    private ResultColumnList realiasSetClauses(FromBaseTable fromBaseTable) throws StandardException {
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        for (int i = 0; i < this._updateColumns.size(); ++i) {
            ResultColumn resultColumn = (ResultColumn)this._updateColumns.elementAt(i);
            TableName tableName = fromBaseTable.getTableName();
            ColumnReference columnReference = new ColumnReference(resultColumn.getReference().getColumnName(), tableName, this.getContextManager());
            columnReference.setMergeTableID(2);
            ResultColumn resultColumn2 = new ResultColumn(columnReference, resultColumn.getExpression(), this.getContextManager());
            resultColumnList.addResultColumn(resultColumn2);
        }
        return resultColumnList;
    }

    private ResultSetNode getBoundSelectUnderUpdate() throws StandardException {
        ResultSetNode resultSetNode = this._dml.resultSet;
        while (resultSetNode != null) {
            if (resultSetNode instanceof SelectNode) {
                return resultSetNode;
            }
            if (!(resultSetNode instanceof SingleChildResultSetNode)) break;
            resultSetNode = ((SingleChildResultSetNode)resultSetNode).getChildResult();
        }
        throw StandardException.newException("0A000.S", new Object[0]);
    }

    private void bindSetClauses(MergeNode mergeNode, FromList fromList, FromTable fromTable, ResultColumnList resultColumnList) throws StandardException {
        resultColumnList.replaceOrForbidDefaults(fromTable.getTableDescriptor(), this._updateColumns, true);
        this.bindExpressions(resultColumnList, fromList);
        for (int i = 0; i < this._updateColumns.size(); ++i) {
            ResultColumn resultColumn = (ResultColumn)this._updateColumns.elementAt(i);
            ColumnReference columnReference = resultColumn.getReference();
            columnReference.setMergeTableID(2);
        }
        List<ColumnReference> list = this.getColumnReferences(this._updateColumns);
        for (ColumnReference columnReference : list) {
            mergeNode.associateColumn(fromList, columnReference, 0);
        }
    }

    private void buildThenColumnsForUpdate(FromList fromList, FromTable fromTable, ResultColumnList resultColumnList, ResultColumnList resultColumnList2, ResultColumnList resultColumnList3) throws StandardException {
        TableDescriptor tableDescriptor = fromTable.getTableDescriptor();
        HashSet<String> hashSet = this.getChangedColumnNames();
        HashSet<String> hashSet2 = this.getChangedGeneratedColumnNames(tableDescriptor, hashSet);
        this._thenColumns = resultColumnList.copyListAndObjects();
        for (int i = 0; i < this._thenColumns.size(); ++i) {
            ResultColumn resultColumn;
            Object object;
            ResultColumn resultColumn2 = (ResultColumn)this._thenColumns.elementAt(i);
            boolean bl = i >= resultColumnList2.size();
            boolean bl2 = this.isRowLocation(resultColumn2);
            ValueNode valueNode = resultColumn2.getExpression();
            if (bl2) continue;
            String string = resultColumn2.getName();
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(string);
            boolean bl3 = false;
            if (columnDescriptor.isAutoincrement() && resultColumn2.getExpression() instanceof NumericConstantNode && (object = ((NumericConstantNode)resultColumn2.getExpression()).getValue()) == null) {
                resultColumn = this.makeAutoGenRC(fromTable, resultColumn2, i + 1);
                resultColumn.setVirtualColumnId(resultColumn2.getVirtualColumnId());
                this._thenColumns.setElementAt(resultColumn, i);
                continue;
            }
            if (!resultColumn2.isAutoincrement() && resultColumn2.getExpression() instanceof VirtualColumnNode) {
                resultColumn2.setExpression(new UntypedNullConstantNode(this.getContextManager()));
            }
            if (columnDescriptor.hasGenerationClause()) {
                if (bl && hashSet2.contains(string)) {
                    resultColumn2.setExpression(new UntypedNullConstantNode(this.getContextManager()));
                    continue;
                }
                object = new ColumnReference(string, fromTable.getTableName(), this.getContextManager());
                resultColumn2.setExpression((ValueNode)object);
                resultColumn2.setColumnDescriptor(null, null);
                continue;
            }
            if (bl) {
                for (int j = 0; j < resultColumnList2.size(); ++j) {
                    resultColumn = (ResultColumn)resultColumnList2.elementAt(j);
                    if (!string.equals(resultColumn.getName())) continue;
                    ResultColumn resultColumn3 = null;
                    ResultColumn resultColumn4 = (ResultColumn)resultColumnList3.elementAt(j);
                    if (resultColumn4.wasDefaultColumn() || resultColumn4.getExpression() instanceof UntypedNullConstantNode) {
                        if (!columnDescriptor.isAutoincrement()) {
                            ValueNode valueNode2 = resultColumn2.getExpression();
                            if (!(valueNode2 instanceof ColumnReference)) continue;
                            resultColumn2.setExpression(new UntypedNullConstantNode(this.getContextManager()));
                            continue;
                        }
                        resultColumn3 = this.makeAutoGenRC(fromTable, resultColumn2, i + 1);
                    } else {
                        resultColumn3 = resultColumn4.cloneMe();
                        resultColumn3.setType(resultColumn2.getTypeServices());
                    }
                    resultColumn3.setVirtualColumnId(resultColumn2.getVirtualColumnId());
                    this._thenColumns.setElementAt(resultColumn3, i);
                    bl3 = true;
                    break;
                }
            }
            if (!(bl3 || (object = (DefaultInfoImpl)columnDescriptor.getDefaultInfo()) == null || ((DefaultInfoImpl)object).isGeneratedColumn() || columnDescriptor.isAutoincrement())) {
                this._thenColumns.setDefault(resultColumn2, columnDescriptor, (DefaultInfoImpl)object);
                bl3 = true;
            }
            object = (ResultColumn)this._thenColumns.elementAt(i);
            ((ResultColumn)object).setName(columnDescriptor.getColumnName());
            ((ResultColumn)object).resetAutoincrementGenerated();
        }
    }

    private HashSet<String> getChangedColumnNames() throws StandardException {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this._updateColumns.size(); ++i) {
            String string = ((ResultColumn)this._updateColumns.elementAt(i)).getName();
            hashSet.add(string);
        }
        return hashSet;
    }

    private HashSet<String> getChangedGeneratedColumnNames(TableDescriptor tableDescriptor, HashSet<String> hashSet) throws StandardException {
        HashSet<String> hashSet2 = new HashSet<String>();
        block0: for (ColumnDescriptor columnDescriptor : tableDescriptor.getColumnDescriptorList()) {
            String[] stringArray;
            if (!columnDescriptor.hasGenerationClause()) continue;
            if (hashSet.contains(columnDescriptor.getColumnName())) {
                hashSet2.add(columnDescriptor.getColumnName());
                continue;
            }
            for (String string : stringArray = columnDescriptor.getDefaultInfo().getReferencedColumnNames()) {
                if (!hashSet.contains(string)) continue;
                hashSet2.add(string);
                continue block0;
            }
        }
        return hashSet2;
    }

    private void bindDelete(DataDictionary dataDictionary, FromList fromList, FromBaseTable fromBaseTable) throws StandardException {
        IgnoreFilter ignoreFilter = new IgnoreFilter();
        this.getCompilerContext().addPrivilegeFilter(ignoreFilter);
        FromBaseTable fromBaseTable2 = new FromBaseTable(fromBaseTable.getTableNameField(), null, null, null, this.getContextManager());
        FromList fromList2 = new FromList(this.getContextManager());
        fromList2.addFromTable(fromBaseTable2);
        fromList2.bindTables(dataDictionary, new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager()));
        CurrentOfNode currentOfNode = CurrentOfNode.makeForMerge(CURRENT_OF_NODE_NAME, fromBaseTable2, this.getContextManager());
        FromList fromList3 = new FromList(this.getContextManager());
        fromList3.addFromTable(currentOfNode);
        SelectNode selectNode = new SelectNode(null, fromList3, null, null, null, null, null, this.getContextManager());
        this._dml = new DeleteNode(fromBaseTable.getTableNameField(), selectNode, this, this.getContextManager());
        this.getCompilerContext().removePrivilegeFilter(ignoreFilter);
        this._dml.bindStatement();
        this.buildThenColumnsForDelete();
    }

    private void buildThenColumnsForDelete() throws StandardException {
        ResultColumnList resultColumnList = this._dml.resultSet.getResultColumns();
        for (int i = 0; i < resultColumnList.size(); ++i) {
            ResultColumn resultColumn;
            ResultColumn resultColumn2 = (ResultColumn)resultColumnList.elementAt(i);
            ValueNode valueNode = resultColumn2.getExpression();
            if (valueNode instanceof ColumnReference) {
                ColumnReference columnReference = (ColumnReference)((ColumnReference)valueNode).getClone();
                resultColumn = new ResultColumn(columnReference, (ValueNode)columnReference, this.getContextManager());
            } else {
                resultColumn = resultColumn2.cloneMe();
            }
            this._thenColumns.addResultColumn(resultColumn);
        }
    }

    private void bindInsert(DataDictionary dataDictionary, MergeNode mergeNode, FromList fromList, FromBaseTable fromBaseTable) throws StandardException {
        QueryTreeNode queryTreeNode;
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        for (int i = 0; i < this._insertValues.size(); ++i) {
            queryTreeNode = (ResultColumn)this._insertValues.elementAt(i);
            resultColumnList.addResultColumn(queryTreeNode.cloneMe());
        }
        resultColumnList.replaceOrForbidDefaults(fromBaseTable.getTableDescriptor(), this._insertColumns, true);
        this.bindExpressions(resultColumnList, fromList);
        this.bindInsertValues(fromList, fromBaseTable);
        FromList fromList2 = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
        fromList2.addElement(fromList.elementAt(0));
        this.bindExpressions(this._insertValues, fromList2);
        queryTreeNode = new SelectNode(resultColumnList, fromList, null, null, null, null, null, this.getContextManager());
        this._dml = new InsertNode(fromBaseTable.getTableNameField(), this._insertColumns, (ResultSetNode)queryTreeNode, this, null, null, null, null, false, this.getContextManager());
        this._dml.bindStatement();
        this.buildThenColumnsForInsert(fromList, fromBaseTable, this._dml.resultSet.getResultColumns(), this._insertColumns, this._insertValues);
    }

    private void bindInsertValues(FromList fromList, FromTable fromTable) throws StandardException {
        TableDescriptor tableDescriptor = fromTable.getTableDescriptor();
        if (this._insertColumns == null) {
            this._insertColumns = this.buildFullColumnList(tableDescriptor);
        }
        if (this._insertColumns.size() != this._insertValues.size()) {
            throw StandardException.newException("42802", new Object[0]);
        }
        for (int i = 0; i < this._insertValues.size(); ++i) {
            ResultColumn resultColumn = (ResultColumn)this._insertValues.elementAt(i);
            String string = ((ResultColumn)this._insertColumns.elementAt(i)).getName();
            ValueNode valueNode = resultColumn.getExpression();
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(string);
            if (columnDescriptor == null) continue;
            if (columnDescriptor.isAutoincAlways() && !(valueNode instanceof DefaultNode)) {
                throw StandardException.newException("42Z23", string);
            }
            if (!columnDescriptor.isAutoincrement() || !(valueNode instanceof UntypedNullConstantNode)) continue;
            throw StandardException.newException("23502", string);
        }
        this._insertValues.replaceOrForbidDefaults(fromTable.getTableDescriptor(), this._insertColumns, true);
        this.bindExpressions(this._insertValues, fromList);
    }

    private ResultColumnList buildFullColumnList(TableDescriptor tableDescriptor) throws StandardException {
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        ColumnDescriptorList columnDescriptorList = tableDescriptor.getColumnDescriptorList();
        int n = columnDescriptorList.size();
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(i);
            ColumnReference columnReference = new ColumnReference(columnDescriptor.getColumnName(), null, this.getContextManager());
            ResultColumn resultColumn = new ResultColumn(columnReference, null, this.getContextManager());
            resultColumnList.addResultColumn(resultColumn);
        }
        return resultColumnList;
    }

    private void buildThenColumnsForInsert(FromList fromList, FromTable fromTable, ResultColumnList resultColumnList, ResultColumnList resultColumnList2, ResultColumnList resultColumnList3) throws StandardException {
        boolean bl = this.getCompilerContext().skipTypePrivileges(true);
        TableDescriptor tableDescriptor = fromTable.getTableDescriptor();
        this._thenColumns = resultColumnList.copyListAndObjects();
        for (int i = 0; i < this._thenColumns.size(); ++i) {
            DefaultInfoImpl defaultInfoImpl;
            ResultColumn resultColumn = (ResultColumn)this._thenColumns.elementAt(i);
            String string = resultColumn.getName();
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(string);
            boolean bl2 = false;
            if (!resultColumn.isAutoincrement() && resultColumn.getExpression() instanceof VirtualColumnNode) {
                resultColumn.setExpression(new UntypedNullConstantNode(this.getContextManager()));
            }
            if (columnDescriptor.hasGenerationClause()) {
                resultColumn.setExpression(new UntypedNullConstantNode(this.getContextManager()));
                continue;
            }
            for (int j = 0; j < resultColumnList2.size(); ++j) {
                ResultColumn resultColumn2 = (ResultColumn)resultColumnList2.elementAt(j);
                if (!string.equals(resultColumn2.getName())) continue;
                ResultColumn resultColumn3 = null;
                ResultColumn resultColumn4 = (ResultColumn)resultColumnList3.elementAt(j);
                if (resultColumn4.wasDefaultColumn() || resultColumn4.getExpression() instanceof UntypedNullConstantNode) {
                    if (!columnDescriptor.isAutoincrement()) {
                        ValueNode valueNode = resultColumn.getExpression();
                        if (!(valueNode instanceof ColumnReference)) continue;
                        resultColumn.setExpression(new UntypedNullConstantNode(this.getContextManager()));
                        continue;
                    }
                    resultColumn3 = this.makeAutoGenRC(fromTable, resultColumn, i + 1);
                } else {
                    resultColumn3 = resultColumn4.cloneMe();
                    resultColumn3.setType(resultColumn.getTypeServices());
                }
                resultColumn3.setVirtualColumnId(resultColumn.getVirtualColumnId());
                this._thenColumns.setElementAt(resultColumn3, i);
                bl2 = true;
                break;
            }
            if (!(bl2 || (defaultInfoImpl = (DefaultInfoImpl)columnDescriptor.getDefaultInfo()) == null || defaultInfoImpl.isGeneratedColumn() || columnDescriptor.isAutoincrement())) {
                this._thenColumns.setDefault(resultColumn, columnDescriptor, defaultInfoImpl);
                bl2 = true;
            }
            ResultColumn resultColumn5 = (ResultColumn)this._thenColumns.elementAt(i);
            resultColumn5.setName(columnDescriptor.getColumnName());
        }
        this.getCompilerContext().skipTypePrivileges(bl);
    }

    private ResultColumn makeAutoGenRC(FromTable fromTable, ResultColumn resultColumn, int n) throws StandardException {
        String string = resultColumn.getName();
        ColumnReference columnReference = new ColumnReference(string, fromTable.getTableName(), this.getContextManager());
        ResultColumn resultColumn2 = new ResultColumn(columnReference, null, this.getContextManager());
        VirtualColumnNode virtualColumnNode = new VirtualColumnNode(fromTable, resultColumn2, n, this.getContextManager());
        ResultColumn resultColumn3 = new ResultColumn(columnReference, (ValueNode)virtualColumnNode, this.getContextManager());
        resultColumn3.setType(resultColumn.getTypeServices());
        return resultColumn3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindExpressions(ResultColumnList resultColumnList, FromList fromList) throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        int n = compilerContext.getReliability();
        boolean bl = compilerContext.skipTypePrivileges(true);
        compilerContext.setReliability(n | 0x2000);
        try {
            resultColumnList.bindExpressions(fromList, new SubqueryList(this.getContextManager()), new ArrayList<AggregateNode>());
        }
        finally {
            compilerContext.setReliability(n);
            compilerContext.skipTypePrivileges(bl);
        }
    }

    private void forbidSubqueries() throws StandardException {
        this.forbidSubqueries(this._matchingRefinement);
        this.forbidSubqueries(this._updateColumns);
        this.forbidSubqueries(this._insertColumns);
        this.forbidSubqueries(this._insertValues);
    }

    private void forbidSubqueries(ResultColumnList resultColumnList) throws StandardException {
        if (resultColumnList != null) {
            for (int i = 0; i < resultColumnList.size(); ++i) {
                this.forbidSubqueries((ValueNode)resultColumnList.elementAt(i));
            }
        }
    }

    private void forbidSubqueries(ValueNode valueNode) throws StandardException {
        if (valueNode != null) {
            CollectNodesVisitor<SubqueryNode> collectNodesVisitor = new CollectNodesVisitor<SubqueryNode>(SubqueryNode.class);
            valueNode.accept(collectNodesVisitor);
            if (collectNodesVisitor.getList().size() > 0) {
                throw StandardException.newException("42XAO", new Object[0]);
            }
        }
    }

    void optimize() throws StandardException {
        this._dml.optimizeStatement();
    }

    ConstantAction makeConstantAction(ActivationClassBuilder activationClassBuilder) throws StandardException {
        String string = null;
        if (this._matchingRefinement != null) {
            MethodBuilder methodBuilder = activationClassBuilder.newUserExprFun();
            this._matchingRefinement.generateExpression(activationClassBuilder, methodBuilder);
            methodBuilder.methodReturn();
            methodBuilder.complete();
            string = methodBuilder.getName();
        }
        return this.getGenericConstantActionFactory().getMatchingClauseConstantAction(this.getClauseType(), string, this.buildThenColumnSignature(), this._rowMakingMethodName, this._resultSetFieldName, this._actionMethodName, this._dml.makeConstantAction());
    }

    private int getClauseType() {
        if (this.isUpdateClause()) {
            return 1;
        }
        if (this.isInsertClause()) {
            return 0;
        }
        return 2;
    }

    private ResultDescription buildThenColumnSignature() throws StandardException {
        ResultColumnDescriptor[] resultColumnDescriptorArray = this._thenColumns.makeResultDescriptors();
        return this.getLanguageConnectionContext().getLanguageFactory().getResultDescription(resultColumnDescriptorArray, "MERGE");
    }

    void generate(ActivationClassBuilder activationClassBuilder, ResultColumnList resultColumnList, ResultSetNode resultSetNode, HalfOuterJoinNode halfOuterJoinNode, int n) throws StandardException {
        this._clauseNumber = n;
        this.adjustMatchingRefinement(resultColumnList, resultSetNode);
        this.generateInsertUpdateRow(activationClassBuilder, resultColumnList, resultSetNode, halfOuterJoinNode);
        this._actionMethodName = "mergeActionMethod_" + this._clauseNumber;
        MethodBuilder methodBuilder = activationClassBuilder.getClassBuilder().newMethodBuilder(1, "org.apache.derby.iapi.sql.ResultSet", this._actionMethodName);
        methodBuilder.addThrownException("org.apache.derby.iapi.error.StandardException");
        this.remapConstraints();
        this._dml.generate(activationClassBuilder, methodBuilder);
        methodBuilder.methodReturn();
        methodBuilder.complete();
    }

    private void remapConstraints() throws StandardException {
        ValueNode valueNode;
        if (this.isDeleteClause()) {
            return;
        }
        ValueNode valueNode2 = valueNode = this.isInsertClause() ? ((InsertNode)this._dml).checkConstraints : ((UpdateNode)this._dml).checkConstraints;
        if (valueNode != null) {
            List<ColumnReference> list = this.getColumnReferences(valueNode);
            for (ColumnReference columnReference : list) {
                columnReference.getSource().setResultSetNumber(0);
            }
        }
    }

    void generateResultSetField(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this._resultSetFieldName = "mergeResultSetField_" + this._clauseNumber;
        LocalField localField = activationClassBuilder.newFieldDeclaration(1, "org.apache.derby.iapi.sql.execute.NoPutResultSet", this._resultSetFieldName);
        methodBuilder.getField(localField);
    }

    private void generateInsertUpdateRow(ActivationClassBuilder activationClassBuilder, ResultColumnList resultColumnList, ResultSetNode resultSetNode, HalfOuterJoinNode halfOuterJoinNode) throws StandardException {
        this.adjustThenColumns(resultColumnList, resultSetNode, halfOuterJoinNode);
        this._rowMakingMethodName = "mergeRowMakingMethod_" + this._clauseNumber;
        MethodBuilder methodBuilder = activationClassBuilder.getClassBuilder().newMethodBuilder(1, "org.apache.derby.iapi.sql.execute.ExecRow", this._rowMakingMethodName);
        methodBuilder.addThrownException("org.apache.derby.iapi.error.StandardException");
        this._thenColumns.generateEvaluatedRow(activationClassBuilder, methodBuilder, false, true);
    }

    private void adjustMatchingRefinement(ResultColumnList resultColumnList, ResultSetNode resultSetNode) throws StandardException {
        if (this._matchingRefinement != null) {
            this.useGeneratedScan(resultColumnList, resultSetNode, this._matchingRefinement);
        }
    }

    private void adjustThenColumns(ResultColumnList resultColumnList, ResultSetNode resultSetNode, HalfOuterJoinNode halfOuterJoinNode) throws StandardException {
        ResultColumnList resultColumnList2 = resultSetNode.getResultColumns();
        this.useGeneratedScan(resultColumnList, resultSetNode, this._thenColumns);
        int n = this._thenColumns.size() - 1;
        ResultColumn resultColumn = (ResultColumn)this._thenColumns.elementAt(n);
        if (this.isRowLocation(resultColumn)) {
            ResultColumn resultColumn2 = (ResultColumn)resultColumnList2.elementAt(resultColumnList2.size() - 1);
            ValueNode valueNode = resultColumn2.getExpression();
            String string = resultColumn2.getName();
            ColumnReference columnReference = new ColumnReference(string, halfOuterJoinNode.getTableName(), this.getContextManager());
            columnReference.setSource(resultColumn2);
            ResultColumn resultColumn3 = new ResultColumn(string, (ValueNode)columnReference, this.getContextManager());
            this._thenColumns.removeElementAt(n);
            this._thenColumns.addResultColumn(resultColumn3);
        }
    }

    private void useGeneratedScan(ResultColumnList resultColumnList, ResultSetNode resultSetNode, QueryTreeNode queryTreeNode) throws StandardException {
        ResultColumnList resultColumnList2 = resultSetNode.getResultColumns();
        for (ColumnReference columnReference : this.getColumnReferences(queryTreeNode)) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList2.elementAt(this.getSelectListOffset(resultColumnList, columnReference) - 1);
            columnReference.setSource(resultColumn);
        }
    }

    private int getSelectListOffset(ResultColumnList resultColumnList, ValueNode valueNode) throws StandardException {
        int n = resultColumnList.size();
        if (valueNode instanceof ColumnReference) {
            ColumnReference columnReference = (ColumnReference)valueNode;
            String string = columnReference.getColumnName();
            int n2 = this.getMergeTableID(columnReference);
            for (int i = 0; i < n; ++i) {
                ColumnReference columnReference2;
                ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(i);
                ValueNode valueNode2 = resultColumn.getExpression();
                ColumnReference columnReference3 = columnReference2 = valueNode2 instanceof ColumnReference ? (ColumnReference)valueNode2 : null;
                if (columnReference2 == null || this.getMergeTableID(columnReference2) != n2 || !string.equals(columnReference2.getColumnName())) continue;
                return i + 1;
            }
        } else if (valueNode instanceof CurrentRowLocationNode) {
            return n;
        }
        return -1;
    }

    private int getMergeTableID(ColumnReference columnReference) {
        int n = columnReference.getMergeTableID();
        return n;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this._matchingRefinement != null) {
            this._matchingRefinement.accept(visitor);
        }
        if (this._updateColumns != null) {
            this._updateColumns.accept(visitor);
        }
        if (this._insertColumns != null) {
            this._insertColumns.accept(visitor);
        }
        if (this._insertValues != null) {
            this._insertValues.accept(visitor);
        }
        if (this._dml != null) {
            this._dml.accept(visitor);
        }
    }

    @Override
    void printSubNodes(int n) {
    }

    @Override
    public String toString() {
        if (this.isUpdateClause()) {
            return "UPDATE";
        }
        if (this.isInsertClause()) {
            return "INSERT";
        }
        return "DELETE";
    }

    private List<ColumnReference> getColumnReferences(QueryTreeNode queryTreeNode) throws StandardException {
        CollectNodesVisitor<ColumnReference> collectNodesVisitor = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
        queryTreeNode.accept(collectNodesVisitor);
        return collectNodesVisitor.getList();
    }

    private boolean isRowLocation(ResultColumn resultColumn) throws StandardException {
        if (resultColumn.getExpression() instanceof CurrentRowLocationNode) {
            return true;
        }
        DataTypeDescriptor dataTypeDescriptor = resultColumn.getTypeServices();
        return dataTypeDescriptor != null && dataTypeDescriptor.getTypeId().isRefTypeId();
    }
}

