/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.eutils.autonature;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.statet.internal.eutils.autonature.Task;

public class NatureTask
extends Task {
    private final String natureId;
    private final String label;
    private final List<String> required;
    private final List<NatureTask> prev = new ArrayList<NatureTask>(4);
    private final List<NatureTask> prevFlat = new ArrayList<NatureTask>(8);

    private static NatureTask get(List<NatureTask> tasks, String natureId) {
        int size = tasks.size();
        int i = 0;
        while (i < size) {
            NatureTask task = tasks.get(i);
            if (task.getNatureId() == natureId) {
                return task;
            }
            ++i;
        }
        return null;
    }

    public NatureTask(String natureId, String label, List<String> required) {
        this.natureId = natureId;
        this.label = label;
        this.required = required;
    }

    public String getNatureId() {
        return this.natureId;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean isAvailable() {
        return this.label != null;
    }

    public List<String> getRequiredNatureIds() {
        return this.required;
    }

    void addPrev(NatureTask task) {
        if (!this.prev.contains(task)) {
            this.prev.add(task);
        }
    }

    void finish() {
        this.prevFlat.clear();
        int i = 0;
        while (i < this.prev.size()) {
            this.prevFlat.add(this.prev.get(i));
            ++i;
        }
        i = 0;
        while (i < this.prevFlat.size()) {
            List<NatureTask> tasks = this.prevFlat.get((int)i).prev;
            int j = 0;
            while (j < tasks.size()) {
                NatureTask task = tasks.get(j);
                if (task != this && !this.prevFlat.contains(task)) {
                    this.prevFlat.add(task);
                }
                ++j;
            }
            ++i;
        }
    }

    boolean isSubsequentTo(String natureId) {
        NatureTask task = NatureTask.get(this.prevFlat, natureId);
        return task != null && NatureTask.get(task.prevFlat, this.natureId) == null;
    }

    @Override
    public byte check(IProject project, int flags, SubMonitor m) throws CoreException {
        return project.hasNature(this.natureId) ? (byte)1 : 2;
    }

    public String toString() {
        return "NatureTask '" + this.natureId + "'";
    }
}

