/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.PooledObjectState;
import org.apache.commons.pool2.impl.DefaultEvictionPolicy;
import org.apache.commons.pool2.impl.EvictionConfig;
import org.apache.commons.pool2.impl.EvictionPolicy;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.eclipse.statet.internal.rj.servi.APool2NodeFactory;
import org.eclipse.statet.internal.rj.servi.APool2NodeHandler;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.rj.RjInvalidConfigurationException;
import org.eclipse.statet.rj.servi.pool.PoolConfig;

@NonNullByDefault
public class APool2
extends GenericObjectPool<APool2NodeHandler> {
    public static final String CLIENT_ALLOCATION_RENEW_PERIOD_MILLIS_PROPERTY_KEY = "org.eclipse.statet.rj.servi.pool.client.AllocationRenewPeriod.millis";
    public static final int CLIENT_ALLOCATION_RENEW_PERIOD_MILLIS_DEFAULT_VALUE = 600000;
    private static final int CLIENT_ALLOCATION_RENEW_PERIOD_MILLIS_MIN_VALUE = 5000;
    private static final byte CLOSING = 2;
    private static final byte CLOSING_FINALLY = 3;
    private static final byte CLOSED = 4;
    private static final EvictionPolicy<APool2NodeHandler> EVICTION_POLICY = new DefaultEvictionPolicy<APool2NodeHandler>(){

        public boolean evict(EvictionConfig config, PooledObject<APool2NodeHandler> underTest, int idleCount) {
            return super.evict(config, underTest, idleCount) || ((APool2NodeHandler)underTest.getObject()).isEvictRequested(0L);
        }
    };
    private final String id;
    private final APool2NodeFactory factory;
    private int clientAllocationRenewPeriodMillis;
    private volatile byte state;
    private boolean evicting;
    private final Object stateLock = new Object();

    private static GenericObjectPoolConfig<APool2NodeHandler> createAConfig(PoolConfig config) {
        GenericObjectPoolConfig aConfig = new GenericObjectPoolConfig();
        aConfig.setLifo(true);
        aConfig.setTestOnReturn(true);
        aConfig.setTestWhileIdle(false);
        aConfig.setTestOnBorrow(false);
        aConfig.setBlockWhenExhausted(true);
        aConfig.setMaxTotal(config.getMaxTotalCount());
        aConfig.setMaxWaitMillis(config.getMaxWaitTime());
        aConfig.setMinIdle(config.getMinIdleCount());
        aConfig.setMaxIdle(config.getMaxIdleCount());
        aConfig.setMinEvictableIdleTimeMillis(0L);
        aConfig.setSoftMinEvictableIdleTimeMillis(config.getMinIdleTime());
        aConfig.setTimeBetweenEvictionRunsMillis(5000L);
        aConfig.setNumTestsPerEvictionRun(-4);
        aConfig.setEvictorShutdownTimeoutMillis(0L);
        return aConfig;
    }

    public APool2(String id, APool2NodeFactory factory, PoolConfig config) throws RjInvalidConfigurationException {
        super((PooledObjectFactory)factory, APool2.createAConfig(config));
        this.id = id;
        this.clientAllocationRenewPeriodMillis = this.getClientAllocationRenewPeriodMillisDefaultValue();
        factory.setPool(this);
        this.factory = factory;
    }

    public String getId() {
        return this.id;
    }

    public void setConfig(PoolConfig config) {
        this.setConfig(APool2.createAConfig(config));
    }

    public int getMaxIdle() {
        if (this.state != 0) {
            return 0;
        }
        return super.getMaxIdle();
    }

    protected int getClientAllocationRenewPeriodMillisDefaultValue() throws RjInvalidConfigurationException {
        try {
            int millis = 600000;
            String s = System.getProperty(CLIENT_ALLOCATION_RENEW_PERIOD_MILLIS_PROPERTY_KEY);
            if (s != null) {
                millis = Integer.parseInt(s);
            }
            if (millis != -1 && millis < 5000) {
                throw new IllegalArgumentException(String.format("%1$s < %2$s", this.clientAllocationRenewPeriodMillis, 5000));
            }
            return millis;
        }
        catch (Exception e) {
            throw new RjInvalidConfigurationException("AllocationRenewPeriod.millis: " + e.getMessage());
        }
    }

    public int getClientAllocationRenewPeriodMillis() {
        return this.clientAllocationRenewPeriodMillis;
    }

    public APool2NodeHandler borrowObject(String client) throws Exception {
        if (this.state != 0) {
            throw new IllegalStateException("Pool not open");
        }
        this.factory.registerArgs(client);
        try {
            APool2NodeHandler aPool2NodeHandler = (APool2NodeHandler)super.borrowObject();
            return aPool2NodeHandler;
        }
        finally {
            this.factory.clearArgs();
        }
    }

    public boolean isOpen() {
        return this.state == 0;
    }

    public void close() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(long evictionTimeout) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state > 2) {
                return;
            }
            this.state = (byte)2;
        }
        long evictNanos = APool2NodeHandler.evictNanos(evictionTimeout);
        boolean evictDirect = evictionTimeout == 0L;
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.clear();
        ImList<APool2NodeHandler> objects = this.factory.getAllObjects();
        for (APool2NodeHandler poolObj : objects) {
            poolObj.doEvict(evictNanos, evictDirect);
        }
        if (this.state > 2) {
            return;
        }
        this.setNumTestsPerEvictionRun(512);
        this.setTimeBetweenEvictionRunsMillis(500L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeFinally() {
        super.close();
        Object object = this.stateLock;
        synchronized (object) {
            this.state = (byte)4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict() throws Exception {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state > 2 || this.evicting) {
                return;
            }
            this.evicting = true;
        }
        try {
            int evicted;
            do {
                evicted = 0;
                long nanos = APool2NodeHandler.safeNanos(System.nanoTime());
                ImList<APool2NodeHandler> objects = this.factory.getAllObjects();
                for (APool2NodeHandler poolObj : objects) {
                    poolObj.checkClientLost(nanos);
                    if (!poolObj.isEvictRequested(nanos) || poolObj.getPooledObject().getState() == PooledObjectState.INVALID) continue;
                    try {
                        this.invalidateObject(poolObj);
                        ++evicted;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            } while (evicted > 0);
            super.evict();
            Object object2 = this.stateLock;
            synchronized (object2) {
                block16: {
                    if (this.state == 2 && this.factory.getNumAll() <= 0) break block16;
                    return;
                }
                this.state = (byte)3;
            }
            this.closeFinally();
        }
        finally {
            this.evicting = false;
        }
    }

    public EvictionPolicy<APool2NodeHandler> getEvictionPolicy() {
        return EVICTION_POLICY;
    }
}

