/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.eclient.graphics;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusChangeListener;
import org.eclipse.statet.rj.eclient.graphics.ERGraphic;
import org.eclipse.statet.rj.eclient.graphics.RGraphicComposite;
import org.eclipse.statet.rj.eclient.graphics.RGraphicCompositeActionSet;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.services.IServiceLocator;

public class RGraphicPage
extends Page
implements StatusChangeListener {
    private final ERGraphic graphic;
    private RGraphicComposite control;
    private RGraphicCompositeActionSet actions;
    private StatusLineContributionItem locationStatusItem;
    private String locationStatusText;
    private RGraphicCompositeActionSet.LocationListener mouseLocationListener;

    public RGraphicPage(ERGraphic graphic) {
        this.graphic = graphic;
    }

    protected ERGraphic getGraphic() {
        return this.graphic;
    }

    protected void init(StatusLineContributionItem locationStatusItem) {
        this.locationStatusItem = locationStatusItem;
    }

    public void createControl(Composite parent) {
        this.control = new RGraphicComposite(parent, this.graphic);
        this.initActions((IServiceLocator)this.getSite(), this.getSite().getActionBars());
        this.graphic.addMessageListener(this);
        this.onStatusChanged(this.graphic.getMessage());
    }

    protected void initActions(IServiceLocator serviceLocator, IActionBars actionBars) {
        IHandlerService handlerService = (IHandlerService)serviceLocator.getService(IHandlerService.class);
        AbstractHandler refreshHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                RGraphicPage.this.control.redrawGraphic();
                return null;
            }
        };
        handlerService.activateHandler("org.eclipse.ui.file.refresh", (IHandler)refreshHandler);
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.insertBefore("additions", (IContributionItem)new Separator("context"));
        toolBar.insertBefore("additions", (IContributionItem)new Separator("size"));
        this.actions = this.createActionSet();
        this.actions.setGraphic(this.graphic);
        this.actions.initActions(serviceLocator);
        this.actions.contributeToActionsBars(serviceLocator, actionBars);
        if (this.locationStatusItem != null) {
            this.mouseLocationListener = new RGraphicCompositeActionSet.LocationListener(){
                final DecimalFormat format = new DecimalFormat("0.0####", new DecimalFormatSymbols(Locale.US));

                @Override
                public void loading() {
                    if (RGraphicPage.this.locationStatusItem != null) {
                        RGraphicPage.this.locationStatusItem.setText("...");
                    }
                }

                @Override
                public void located(double x, double y) {
                    if (RGraphicPage.this.locationStatusItem != null && UIAccess.isOkToUse((Control)RGraphicPage.this.control)) {
                        if (Double.isNaN(x) || Double.isInfinite(x) || Double.isNaN(y) || Double.isInfinite(y)) {
                            RGraphicPage.this.locationStatusText = "NA";
                        } else {
                            StringBuilder sb = new StringBuilder(32);
                            sb.append('(');
                            sb.append(this.format.format(x));
                            sb.append(", ");
                            sb.append(this.format.format(y));
                            sb.append(')');
                            RGraphicPage.this.locationStatusText = sb.toString();
                        }
                        RGraphicPage.this.locationStatusItem.setText(RGraphicPage.this.locationStatusText);
                    }
                }
            };
            this.actions.addMouseClickLocationListener(this.mouseLocationListener);
        }
    }

    protected RGraphicCompositeActionSet createActionSet() {
        return new RGraphicCompositeActionSet(this.control);
    }

    public void onStatusChanged(Status status) {
        String message = status.getSeverity() > 0 ? status.getMessage() : null;
        this.getSite().getActionBars().getStatusLineManager().setMessage(message);
    }

    public Control getControl() {
        return this.control;
    }

    protected RGraphicComposite getGraphicComposite() {
        return this.control;
    }

    public void setFocus() {
        this.control.setFocus();
    }

    public void dispose() {
        if (this.actions != null) {
            this.actions.dispose();
            this.actions = null;
        }
        if (this.graphic != null) {
            this.graphic.removeMessageListener(this);
        }
        super.dispose();
    }
}

