/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.net.core.ssh;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.net.CommonsNet;
import org.eclipse.statet.jcommons.net.Port;
import org.eclipse.statet.jcommons.net.core.RemoteTarget;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.StatusException;

@NonNullByDefault
public class SshTarget
implements RemoteTarget {
    public static final String TYPE = "SSH";
    private final String host;
    private final Port port;
    private final String username;
    private final String targetId;
    private volatile URI uri;

    public SshTarget(String host, @Nullable Port port, String username) throws StatusException {
        try {
            this.host = ObjectUtils.nonNullAssert(host);
            this.port = port != null ? port : CommonsNet.SSH_DEFAULT_PORT;
            this.username = ObjectUtils.nonNullAssert(username);
            if (this.host.isEmpty()) {
                throw new IllegalArgumentException("host (hostname/IP) is missing");
            }
            if (this.username.isEmpty()) {
                throw new IllegalArgumentException("username is missing");
            }
            this.uri = new URI("ssh", this.username, this.host, this.port.get(), null, null, null);
            this.targetId = this.uri.toString();
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            throw new StatusException(new ErrorStatus("org.eclipse.statet.jcommons.util", "Invalid SSH target.", e));
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public Port getPort() {
        return this.port;
    }

    public int getPortNum() {
        return this.port.get();
    }

    public String getUsername() {
        return this.username;
    }

    public URI getUri() {
        return this.uri;
    }

    public int hashCode() {
        return this.targetId.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            return this.targetId.equals(((SshTarget)obj).targetId);
        }
        return false;
    }

    public String toString() {
        return this.targetId;
    }
}

