/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.wikitext.r.ui.editors;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.statet.docmlet.tex.ui.editors.TexEditorBuild;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextModel;
import org.eclipse.statet.docmlet.wikitext.core.project.WikitextIssues;
import org.eclipse.statet.docmlet.wikitext.ui.editors.WikitextEditorBuild;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.issues.core.IssueTypeSet;
import org.eclipse.statet.ltk.ui.sourceediting.SourceAnnotationModel;
import org.eclipse.statet.ltk.ui.sourceediting.SourceDocumentProvider;
import org.eclipse.statet.r.ui.editors.REditorBuild;
import org.eclipse.statet.redocs.wikitext.r.core.model.WikidocRweaveSourceUnit;
import org.eclipse.statet.yaml.ui.editors.YamlEditorBuild;

@NonNullByDefault
public class WikidocRweaveDocumentProvider
extends SourceDocumentProvider<WikidocRweaveSourceUnit>
implements Disposable {
    private static final IssueTypeSet ISSUE_TYPE_SET = new IssueTypeSet("org.eclipse.statet.redocs.wikitext.r", WikitextIssues.TASK_CATEGORY, ImCollections.newList((Object[])new IssueTypeSet.ProblemCategory[]{WikitextEditorBuild.WIKIDOC_MODEL_PROBLEM_CATEGORY, YamlEditorBuild.YAML_MODEL_PROBLEM_CATEGORY, TexEditorBuild.LTX_MODEL_PROBLEM_CATEGORY, REditorBuild.R_MODEL_PROBLEM_CATEGORY}));
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable SettingsChangeNotifier.ChangeListener editorPrefListener = new SettingsChangeNotifier.ChangeListener(){

        public void settingsChanged(Set<String> groupIds) {
            if (groupIds.contains("r/r.editor/build.options") || groupIds.contains("Wikitext/editor/build")) {
                WikidocRweaveDocumentProvider.this.updateEditorPrefs();
            }
        }
    };
    private boolean handleTemporaryDocProblems;
    private boolean handleTemporaryRProblems;

    public WikidocRweaveDocumentProvider() {
        super("WikidocRweave", null, ISSUE_TYPE_SET);
        PreferencesUtil.getSettingsChangeNotifier().addChangeListener(this.editorPrefListener);
        PreferenceAccess access = EPreferences.getInstancePrefs();
        this.handleTemporaryDocProblems = (Boolean)access.getPreferenceValue((Preference)WikitextEditorBuild.PROBLEMCHECKING_ENABLED_PREF);
        this.handleTemporaryRProblems = (Boolean)access.getPreferenceValue((Preference)REditorBuild.PROBLEMCHECKING_ENABLED_PREF);
    }

    public void dispose() {
        if (this.editorPrefListener != null) {
            PreferencesUtil.getSettingsChangeNotifier().removeChangeListener(this.editorPrefListener);
            this.editorPrefListener = null;
        }
    }

    private void updateEditorPrefs() {
        PreferenceAccess access = EPreferences.getInstancePrefs();
        boolean newHandleTemporaryDocProblems = (Boolean)access.getPreferenceValue((Preference)WikitextEditorBuild.PROBLEMCHECKING_ENABLED_PREF);
        boolean newHandleTemporaryRProblems = (Boolean)access.getPreferenceValue((Preference)REditorBuild.PROBLEMCHECKING_ENABLED_PREF);
        if (this.handleTemporaryDocProblems != newHandleTemporaryDocProblems || this.handleTemporaryRProblems != newHandleTemporaryRProblems) {
            this.handleTemporaryDocProblems = newHandleTemporaryRProblems;
            this.handleTemporaryRProblems = newHandleTemporaryRProblems;
            WikitextModel.getWikidocModelManager().refresh(Ltk.EDITOR_CONTEXT);
        }
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new ThisAnnotationModel((IResource)file);
    }

    private class ThisAnnotationModel
    extends SourceAnnotationModel {
        public ThisAnnotationModel(IResource resource) {
            super(resource, WikidocRweaveDocumentProvider.this.getIssueTypeSet());
        }

        protected boolean isHandlingTemporaryProblems(IssueTypeSet.ProblemCategory issueCategory) {
            if (issueCategory != null && issueCategory.getId() == "R") {
                return WikidocRweaveDocumentProvider.this.handleTemporaryRProblems;
            }
            return WikidocRweaveDocumentProvider.this.handleTemporaryDocProblems;
        }
    }
}

