/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.export.core;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.export.core.Messages;
import org.eclipse.swtchart.extensions.core.BaseChart;

public class ExportSettingsDialog
extends TitleAreaDialog {
    private BaseChart baseChart;
    private Combo comboScaleX;
    private Combo comboScaleY;
    private Combo comboExportOption;
    private int indexAxisX;
    private int indexAxisY;
    private boolean exportVisibleOnly;
    private static final String SERIES_ALL = Messages.getString("ALL_SERIES");
    private static final String SERIES_VISIBLE = Messages.getString("VISIBLE_SERIES");
    private String[] exportOptions;

    public ExportSettingsDialog(Shell parent, BaseChart baseChart) {
        super(parent);
        this.baseChart = baseChart;
        this.exportOptions = new String[]{SERIES_ALL, SERIES_VISIBLE};
    }

    public void create() {
        super.create();
        this.setTitle(Messages.getString("EXPORT_AXIS_SELECTION"));
        this.setMessage(Messages.getString("SELECT_X_Y_TO_EXPORT"), 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.createSelectionAxisX(container);
        this.createSelectionAxisY(container);
        this.createExportOptionSelection(container);
        return composite;
    }

    private void createSelectionAxisX(Composite container) {
        Label label = new Label(container, 0);
        label.setText(Messages.getString("X_AXIS"));
        String[] axisLabelsX = this.baseChart.getAxisLabels("X_AXIS");
        this.comboScaleX = new Combo(container, 8);
        this.comboScaleX.setItems(axisLabelsX);
        this.comboScaleX.setLayoutData((Object)new GridData(768));
        if (axisLabelsX.length > 0) {
            this.comboScaleX.select(0);
        }
    }

    private void createSelectionAxisY(Composite container) {
        Label label = new Label(container, 0);
        label.setText(Messages.getString("Y_AXIS"));
        String[] axisLabelsY = this.baseChart.getAxisLabels("Y_AXIS");
        this.comboScaleY = new Combo(container, 8);
        this.comboScaleY.setItems(axisLabelsY);
        this.comboScaleY.setLayoutData((Object)new GridData(768));
        if (axisLabelsY.length > 0) {
            this.comboScaleY.select(0);
        }
    }

    private void createExportOptionSelection(Composite container) {
        Label label = new Label(container, 0);
        label.setText(Messages.getString("EXPORT"));
        this.comboExportOption = new Combo(container, 8);
        this.comboExportOption.setItems(this.exportOptions);
        this.comboExportOption.setLayoutData((Object)new GridData(768));
        if (this.exportOptions.length > 0) {
            this.comboExportOption.select(0);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveInput() {
        this.indexAxisX = this.comboScaleX.getSelectionIndex();
        this.indexAxisY = this.comboScaleY.getSelectionIndex();
        this.exportVisibleOnly = SERIES_VISIBLE.equals(this.comboExportOption.getText().trim());
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    public int getIndexAxisSelectionX() {
        return this.indexAxisX;
    }

    public int getIndexAxisSelectionY() {
        return this.indexAxisY;
    }

    public boolean isExportVisibleOnly() {
        return this.exportVisibleOnly;
    }
}

