/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.internal;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.tea.core.internal.TaskProgressExtendedTracker;
import org.eclipse.tea.core.services.TaskProgressTracker;

public class TaskProgressTrackerImpl
implements TaskProgressExtendedTracker {
    private final SubMonitor monitor;
    private final ListenerList<TaskProgressExtendedTracker.ProgressListener> listeners = new ListenerList();
    private int currentValue;
    private Object task;

    public TaskProgressTrackerImpl(Object task, SubMonitor monitor) {
        this.monitor = monitor;
        this.task = task;
    }

    @Override
    public Object getTask() {
        return this.task;
    }

    @Override
    public void worked(int amount) {
        this.currentValue += amount;
        this.monitor.worked(amount);
        this.notifyListeners();
    }

    @Override
    public void addListener(TaskProgressExtendedTracker.ProgressListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(TaskProgressExtendedTracker.ProgressListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void notifyListeners() {
        for (TaskProgressExtendedTracker.ProgressListener l : this.listeners) {
            l.progressChanged(this.currentValue);
        }
    }

    @Override
    public boolean isCanceled() {
        return this.monitor.isCanceled();
    }

    @Override
    public void setTaskName(String name) {
        this.monitor.subTask(name);
    }

    public static class RestrictedProgressTrackerImpl
    implements TaskProgressTracker {
        private final TaskProgressTracker delegate;

        public RestrictedProgressTrackerImpl(TaskProgressTracker delegate) {
            this.delegate = delegate;
        }

        @Override
        public void worked(int amount) {
        }

        @Override
        public boolean isCanceled() {
            return this.delegate.isCanceled();
        }

        @Override
        public void setTaskName(String name) {
            this.delegate.setTaskName(name);
        }
    }
}

