/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.services;

import java.io.PrintStream;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.inject.Qualifier;
import org.eclipse.tea.core.internal.TimeHelper;

public abstract class TaskingLog {
    private boolean showDebug = true;

    protected void setShowDebug(boolean dbg) {
        this.showDebug = dbg;
    }

    public abstract PrintStream debug();

    public abstract PrintStream info();

    public abstract PrintStream warn();

    public abstract PrintStream error();

    public void info(String msg) {
        this.info(msg, null);
    }

    public void info(String msg, Throwable t) {
        this.write(this.info(), msg, t);
    }

    public void info(String msg, Object ... args) {
        this.info(String.format(msg, args));
    }

    public void debug(String msg) {
        if (this.showDebug) {
            this.debug(msg, null);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.showDebug) {
            this.write(this.debug(), msg, t);
        }
    }

    public void debug(String msg, Object ... args) {
        if (this.showDebug) {
            this.debug(String.format(msg, args));
        }
    }

    public void warn(String msg) {
        this.warn(msg, null);
    }

    public void warn(String msg, Throwable t) {
        this.write(this.warn(), msg, t);
    }

    public void warn(String msg, Object ... args) {
        this.warn(String.format(msg, args));
    }

    public void error(String msg) {
        this.error(msg, null);
    }

    public void error(String msg, Throwable t) {
        this.write(this.error(), msg, t);
    }

    public void error(String msg, Object ... args) {
        this.error(String.format(msg, args));
    }

    public void write(PrintStream s, String msg, Throwable t) {
        s.println(this.formatMessage(msg));
        if (t != null) {
            t.printStackTrace(s);
        }
    }

    public String formatMessage(String msg) {
        return "[TEA " + TimeHelper.getFormattedCurrentTime() + "] " + msg;
    }

    public void bringToFront() {
    }

    @Documented
    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface TaskingLogInit {
    }

    @Documented
    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface TaskingLogQualifier {
        public boolean headless();
    }
}

