/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistryListener2;
import org.eclipse.sirius.business.internal.migration.resource.ResourceFileExtensionPredicate;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.interpreter.InterpreterRegistry;

public class SessionVSMUpdater
implements ViewpointRegistryListener2 {
    private final DAnalysisSessionImpl session;

    public SessionVSMUpdater(DAnalysisSessionImpl session) {
        this.session = Objects.requireNonNull(session);
    }

    @Override
    public void modelerDesciptionFilesLoaded() {
        for (Resource res : SessionVSMUpdater.findAllVSMResources(this.session)) {
            if (!res.isModified() && res.isLoaded() && res.getContents().isEmpty()) {
                this.session.unregisterResourceInCrossReferencer(res);
                res.unload();
            }
            IFile correspondingFile = WorkspaceSynchronizer.getFile((Resource)res);
            if (!res.isLoaded() && correspondingFile != null && correspondingFile.exists()) {
                this.loadVSMInSession(res);
                continue;
            }
            if (!res.getURI().isPlatformPlugin()) continue;
            if (res.isLoaded()) {
                res.unload();
            }
            this.loadVSMInSession(res);
        }
        this.session.notifyListeners(16);
    }

    private void loadVSMInSession(Resource vsmResource) {
        try {
            vsmResource.load(Collections.emptyMap());
            if (vsmResource.isLoaded() && !vsmResource.getContents().isEmpty()) {
                this.session.registerResourceInCrossReferencer(vsmResource);
                InterpreterRegistry.prepareImportsFromSession(this.session.getInterpreter(), this.session);
            }
        }
        catch (IOException e) {
            SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.SessionVSMUpdater_VSMLoadErrorMsg, vsmResource.getURI()), e);
        }
    }

    private static List<Resource> findAllVSMResources(DAnalysisSessionImpl session) {
        EList resources = session.getTransactionalEditingDomain().getResourceSet().getResources();
        return resources.stream().filter(new ResourceFileExtensionPredicate("odesign", true)).collect(Collectors.toList());
    }
}

