/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.internal.merger;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;
import org.eclipse.emf.compare.rcp.internal.EMFCompareRCPMessages;

public class MergerExtensionRegistryListener
extends AbstractRegistryEventListener {
    private static final String TAG_MERGER = "merger";
    private static final String ATT_CLASS = "class";
    private static final String ATT_RANKING = "ranking";
    private final IMerger.Registry mergerRegistry;

    public MergerExtensionRegistryListener(String pluginID, String extensionPointID, ILog log, IMerger.Registry mergerRegistry) {
        super(pluginID, extensionPointID, log);
        this.mergerRegistry = mergerRegistry;
    }

    @Override
    protected boolean readElement(IConfigurationElement element, AbstractRegistryEventListener.Action b) {
        if (element.getName().equals(TAG_MERGER)) {
            if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else if (element.getAttribute(ATT_RANKING) == null) {
                String rankingStr = element.getAttribute(ATT_RANKING);
                try {
                    Integer.parseInt(rankingStr);
                }
                catch (NumberFormatException nfe) {
                    this.log(4, element, EMFCompareRCPMessages.getString("malformed.extension.attribute", ATT_RANKING));
                }
                this.logMissingAttribute(element, ATT_RANKING);
            } else {
                switch (b) {
                    case ADD: {
                        try {
                            IMerger merger = (IMerger)element.createExecutableExtension(ATT_CLASS);
                            merger.setRanking(Integer.parseInt(element.getAttribute(ATT_RANKING)));
                            IMerger previous = this.mergerRegistry.add(merger);
                            if (previous == null) break;
                            this.log(2, element, EMFCompareRCPMessages.getString("duplicate.merger", merger.getClass().getName()));
                        }
                        catch (CoreException e) {
                            this.log(4, element, e.getMessage());
                        }
                        break;
                    }
                    case REMOVE: {
                        this.mergerRegistry.remove(element.getAttribute(ATT_CLASS));
                        break;
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean validateExtensionElement(IConfigurationElement element) {
        boolean ret;
        if (TAG_MERGER.equals(element.getName())) {
            if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
                ret = false;
            } else if (element.getAttribute(ATT_RANKING) == null) {
                String rankingStr = element.getAttribute(ATT_RANKING);
                try {
                    Integer.parseInt(rankingStr);
                }
                catch (NumberFormatException nfe) {
                    this.log(4, element, EMFCompareRCPMessages.getString("malformed.extension.attribute", ATT_RANKING));
                }
                this.logMissingAttribute(element, ATT_RANKING);
                ret = false;
            } else {
                ret = true;
            }
        } else {
            ret = false;
        }
        return ret;
    }

    @Override
    protected boolean addedValid(IConfigurationElement element) {
        try {
            IMerger merger = (IMerger)element.createExecutableExtension(ATT_CLASS);
            merger.setRanking(Integer.parseInt(element.getAttribute(ATT_RANKING)));
            IMerger previous = this.mergerRegistry.add(merger);
            if (previous != null) {
                this.log(2, element, EMFCompareRCPMessages.getString("duplicate.extension", merger.getClass().getName()));
            }
        }
        catch (CoreException e) {
            this.log(4, element, e.getMessage());
        }
        return true;
    }

    @Override
    protected boolean removedValid(IConfigurationElement element) {
        this.mergerRegistry.remove(element.getAttribute(ATT_CLASS));
        return true;
    }
}

