/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.net4j.util.concurrent.NonFairReentrantLock;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IManagedContainerProvider;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.eclipse.net4j.util.lifecycle.LifecycleState;

public class DelegableReentrantLock
extends NonFairReentrantLock
implements ILifecycle,
IManagedContainerProvider {
    private static final long serialVersionUID = 1L;
    private final IManagedContainer container;
    private final IListener containerListener = new ContainerEventAdapter<Object>(){

        @Override
        protected void onAdded(IContainer<Object> container, Object element) {
            DelegableReentrantLock.this.addDelegateDetector(element);
        }

        @Override
        protected void onRemoved(IContainer<Object> container, Object element) {
            DelegableReentrantLock.this.removeDelegateDetector(element);
        }
    };
    private final List<DelegateDetector> delegateDetectors = new CopyOnWriteArrayList<DelegateDetector>();
    private volatile boolean active;

    public DelegableReentrantLock(IManagedContainer container) {
        this.container = container;
    }

    public DelegableReentrantLock() {
        this(IPluginContainer.INSTANCE);
    }

    @Override
    public final IManagedContainer getContainer() {
        return this.container;
    }

    @Override
    public final synchronized void activate() throws LifecycleException {
        if (!this.active) {
            this.active = true;
            Object[] objectArray = this.container.getElements("org.eclipse.net4j.util.concurrent.delegateDetectors");
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.addDelegateDetector(element);
                ++n2;
            }
            this.container.addListener(this.containerListener);
        }
    }

    @Override
    public final synchronized Exception deactivate() {
        if (this.active) {
            try {
                try {
                    this.container.removeListener(this.containerListener);
                    this.delegateDetectors.clear();
                }
                catch (Exception ex) {
                    Exception exception = ex;
                    this.active = false;
                    return exception;
                }
            }
            finally {
                this.active = false;
            }
        }
        return null;
    }

    @Override
    public final LifecycleState getLifecycleState() {
        return this.active ? LifecycleState.ACTIVE : LifecycleState.INACTIVE;
    }

    @Override
    public final boolean isActive() {
        return this.active;
    }

    @Override
    public final void addListener(IListener listener) {
    }

    @Override
    public final void removeListener(IListener listener) {
    }

    @Override
    public final IListener[] getListeners() {
        return EventUtil.NO_LISTENERS;
    }

    @Override
    public final boolean hasListeners() {
        return false;
    }

    @Override
    protected boolean isOwner(Thread thread, Thread owner) {
        if (super.isOwner(thread, owner)) {
            return true;
        }
        return this.isDelegate(thread, owner);
    }

    protected boolean isDelegate(Thread thread, Thread owner) {
        for (DelegateDetector delegateDetector : this.delegateDetectors) {
            if (!delegateDetector.isDelegate(thread, owner)) continue;
            return true;
        }
        return false;
    }

    private void addDelegateDetector(Object element) {
        if (element instanceof DelegateDetector) {
            DelegateDetector delegateDetector = (DelegateDetector)element;
            this.delegateDetectors.add(delegateDetector);
        }
    }

    private void removeDelegateDetector(Object element) {
        if (element instanceof DelegateDetector) {
            DelegateDetector delegateDetector = (DelegateDetector)element;
            this.delegateDetectors.remove(delegateDetector);
        }
    }

    public static interface DelegateDetector {
        public boolean isDelegate(Thread var1, Thread var2);

        public static abstract class Factory
        extends org.eclipse.net4j.util.factory.Factory {
            public static final String PRODUCT_GROUP = "org.eclipse.net4j.util.concurrent.delegateDetectors";

            public Factory(String type) {
                super(PRODUCT_GROUP, type);
            }

            @Override
            public abstract DelegateDetector create(String var1) throws ProductCreationException;
        }
    }
}

