/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.folding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.env.ModuleSource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.corext.SourceRange;
import org.eclipse.dltk.internal.core.SourceMethod;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.text.DocumentCharacterIterator;
import org.eclipse.dltk.ui.text.folding.DefaultElementCommentResolver;
import org.eclipse.dltk.ui.text.folding.IElementCommentResolver;
import org.eclipse.dltk.ui.text.folding.IFoldingStructureProvider;
import org.eclipse.dltk.ui.text.folding.IFoldingStructureProviderExtension;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

@Deprecated
public abstract class AbstractASTFoldingStructureProvider
implements IFoldingStructureProvider,
IFoldingStructureProviderExtension {
    private ITextEditor fEditor;
    private ProjectionListener fProjectionListener;
    private IModelElement fInput;
    private IElementChangedListener fElementListener;
    private final Filter fMemberFilter = new MemberFilter();
    private final Filter fCommentFilter = new CommentFilter();
    private IPreferenceStore fStore;
    private int fBlockLinesMin;
    protected boolean fDocsFolding;
    protected boolean fCommentsFolding;
    protected boolean fFoldNewLines;
    protected boolean fInitCollapseComments;
    protected boolean fInitCollapseHeaderComments;
    protected boolean fInitCollapseClasses;
    protected boolean fInitCollapseMethods;
    private boolean fInitCollapseDocs;

    @Override
    public void install(ITextEditor editor, ProjectionViewer viewer, IPreferenceStore store) {
        this.internalUninstall();
        this.fStore = store;
        if (editor instanceof ScriptEditor) {
            this.fEditor = editor;
            this.fProjectionListener = new ProjectionListener(viewer);
        }
    }

    @Override
    public void uninstall() {
        this.internalUninstall();
    }

    private void internalUninstall() {
        if (this.isInstalled()) {
            this.handleProjectionDisabled();
            this.fProjectionListener.dispose();
            this.fProjectionListener = null;
            this.fEditor = null;
        }
    }

    protected final boolean isInstalled() {
        return this.fEditor != null;
    }

    protected void handleProjectionEnabled() {
        this.handleProjectionDisabled();
        if (this.fEditor instanceof ScriptEditor) {
            this.initialize();
            this.fElementListener = new ElementChangedListener();
            DLTKCore.addElementChangedListener((IElementChangedListener)this.fElementListener);
        }
    }

    protected void handleProjectionDisabled() {
        if (this.fElementListener != null) {
            DLTKCore.removeElementChangedListener((IElementChangedListener)this.fElementListener);
            this.fElementListener = null;
        }
    }

    @Override
    public final void initialize() {
        this.initialize(false);
    }

    @Override
    public final void initialize(boolean isReinit) {
        this.update(this.createInitialContext(isReinit));
    }

    protected FoldingStructureComputationContext createInitialContext(boolean isReinit) {
        this.initializePreferences(this.fStore);
        this.fInput = this.getInputElement();
        if (this.fInput == null) {
            return null;
        }
        return this.createContext(!isReinit);
    }

    protected FoldingStructureComputationContext createInitialContext() {
        return this.createInitialContext(true);
    }

    protected FoldingStructureComputationContext createContext(boolean allowCollapse) {
        if (!this.isInstalled()) {
            return null;
        }
        ProjectionAnnotationModel model = this.getModel();
        if (model == null) {
            return null;
        }
        IDocument doc = this.getDocument();
        if (doc == null) {
            return null;
        }
        return new FoldingStructureComputationContext(doc, model, allowCollapse);
    }

    private IModelElement getInputElement() {
        if (this.fEditor == null) {
            return null;
        }
        return EditorUtility.getEditorInputModelElement((IEditorPart)this.fEditor, false);
    }

    private void update(FoldingStructureComputationContext ctx) {
        if (ctx == null) {
            return;
        }
        HashMap<Object, Position> additions = new HashMap<Object, Position>();
        ArrayList<ScriptProjectionAnnotation> deletions = new ArrayList<ScriptProjectionAnnotation>();
        ArrayList<ScriptProjectionAnnotation> updates = new ArrayList<ScriptProjectionAnnotation>();
        if (!this.computeFoldingStructure(ctx)) {
            return;
        }
        LinkedHashMap<Annotation, Position> updated = ctx.fMap;
        Map<SourceRangeStamp, List<Tuple>> previous = this.computeCurrentStructure(ctx);
        for (Object newAnnotation : updated.keySet()) {
            SourceRangeStamp stamp = ((ScriptProjectionAnnotation)((Object)newAnnotation)).getStamp();
            Position newPosition = (Position)updated.get(newAnnotation);
            List<Tuple> annotations = previous.get(stamp);
            if (annotations == null) {
                additions.put(newAnnotation, newPosition);
                continue;
            }
            Iterator<Tuple> x = annotations.iterator();
            boolean matched = false;
            while (x.hasNext()) {
                Tuple tuple = x.next();
                ScriptProjectionAnnotation existingAnnotation = tuple.annotation;
                Position existingPosition = tuple.position;
                if (((ScriptProjectionAnnotation)((Object)newAnnotation)).isComment() != existingAnnotation.isComment()) continue;
                if (existingPosition != null && (!newPosition.equals((Object)existingPosition) || ctx.allowCollapsing() && existingAnnotation.isCollapsed() != newAnnotation.isCollapsed())) {
                    existingPosition.setOffset(newPosition.getOffset());
                    existingPosition.setLength(newPosition.getLength());
                    if (ctx.allowCollapsing() && existingAnnotation.isCollapsed() != newAnnotation.isCollapsed()) {
                        if (newAnnotation.isCollapsed()) {
                            existingAnnotation.markCollapsed();
                        } else {
                            existingAnnotation.markExpanded();
                        }
                    }
                    updates.add(existingAnnotation);
                }
                matched = true;
                x.remove();
                break;
            }
            if (!matched) {
                additions.put(newAnnotation, newPosition);
            }
            if (!annotations.isEmpty()) continue;
            previous.remove(stamp);
        }
        for (List list : previous.values()) {
            int size = list.size();
            int i = 0;
            while (i < size) {
                deletions.add(((Tuple)list.get((int)i)).annotation);
                ++i;
            }
        }
        Annotation[] annotationArray = new Annotation[deletions.size()];
        deletions.toArray(annotationArray);
        Annotation[] changes = new Annotation[updates.size()];
        updates.toArray(changes);
        ctx.getModel().modifyAnnotations(annotationArray, additions, changes);
    }

    private boolean computeFoldingStructure(FoldingStructureComputationContext ctx) {
        try {
            String contents = ((ISourceReference)this.fInput).getSource();
            return this.computeFoldingStructure(contents, ctx);
        }
        catch (ModelException e) {
            return false;
        }
    }

    protected boolean computeFoldingStructure(String contents, FoldingStructureComputationContext ctx) {
        CodeBlock[] blockRegions = this.getCodeBlocks(contents);
        if (blockRegions == null) {
            return false;
        }
        if (this.fCommentsFolding) {
            IRegion[] commentRegions = this.computeCommentsRanges(contents);
            this.addDocAnnotations(contents, ctx, commentRegions, false);
        }
        String docPartition = this.getDocPartition();
        if (this.fDocsFolding && docPartition != null) {
            IRegion[] commentRegions = this.computeCommentsRanges(contents, docPartition);
            this.addDocAnnotations(contents, ctx, commentRegions, true);
        }
        Document d = new Document(contents);
        MethodCollector methodCollector = new MethodCollector();
        if (this.fInput != null) {
            try {
                this.fInput.accept((IModelElementVisitor)methodCollector);
            }
            catch (ModelException modelException) {
                // empty catch block
            }
        }
        int i = 0;
        while (i < blockRegions.length) {
            block16: {
                CodeBlock codeBlock = blockRegions[i];
                if (this.mayCollapse(codeBlock.statement, ctx)) {
                    Position position;
                    boolean collapseCode = this.initiallyCollapse(codeBlock.statement, ctx);
                    IRegion reg = codeBlock.region;
                    boolean multiline = false;
                    try {
                        multiline = this.isMultilineRegion((IDocument)d, reg);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    IRegion normalized = this.alignRegion(reg, ctx);
                    if (normalized != null && multiline && (position = this.createMemberPosition(normalized)) != null) {
                        try {
                            int len = normalized.getOffset() + normalized.getLength();
                            if (contents.length() == len + 1) {
                                --len;
                            }
                            if (contents.length() >= len) {
                                int hash = contents.substring(normalized.getOffset(), len).hashCode();
                                IModelElement element = null;
                                if (codeBlock.statement instanceof MethodDeclaration) {
                                    MethodDeclaration meth = (MethodDeclaration)codeBlock.statement;
                                    hash = meth.getName().hashCode();
                                    element = methodCollector.get(meth.getNameStart(), meth.getNameEnd() - meth.getNameStart());
                                }
                                SourceRangeStamp codeStamp = new SourceRangeStamp(hash, normalized.getLength());
                                ScriptProjectionAnnotation annotation = new ScriptProjectionAnnotation(collapseCode, false, codeStamp, element);
                                ctx.addProjectionRange(annotation, position);
                            }
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            if (!DLTKCore.DEBUG) break block16;
                            e.printStackTrace();
                        }
                    }
                }
            }
            ++i;
        }
        return true;
    }

    private void addDocAnnotations(String contents, FoldingStructureComputationContext ctx, IRegion[] commentRegions, boolean isDoc) {
        if (commentRegions.length == 0) {
            return;
        }
        IElementCommentResolver commentResolver = this.fInput != null ? this.createElementCommentResolver(this.fInput, contents) : null;
        int i = 0;
        while (i < commentRegions.length) {
            Position position;
            IRegion normalized = this.alignRegion(commentRegions[i], ctx);
            if (normalized != null && (position = this.createCommentPosition(normalized)) != null) {
                int hash = contents.substring(normalized.getOffset(), normalized.getOffset() + normalized.getLength()).hashCode();
                IModelElement element = commentResolver != null ? commentResolver.getElementByCommentPosition(position.offset, 0) : null;
                boolean initCollapse = isDoc ? this.initiallyCollapseDocs(normalized, ctx) : this.initiallyCollapseComments(normalized, ctx);
                ctx.addProjectionRange(new ScriptProjectionAnnotation(initCollapse, true, new SourceRangeStamp(hash, normalized.getLength()), element), position);
            }
            ++i;
        }
    }

    public IElementCommentResolver createElementCommentResolver(IModelElement modelElement, String contents) {
        return new DefaultElementCommentResolver((ISourceModule)modelElement, contents);
    }

    protected int getMinimalFoldableLinesCount() {
        return this.fBlockLinesMin;
    }

    protected void initializePreferences(IPreferenceStore store) {
        this.fBlockLinesMin = store.getInt("editor_folding_lines_limit");
        this.fDocsFolding = store.getBoolean("editor_docs_folding_enabled");
        this.fCommentsFolding = store.getBoolean("editor_comments_folding_enabled");
        this.fFoldNewLines = store.getBoolean("editor_comments_folding_join_newlines");
        this.fInitCollapseComments = store.getBoolean("editor_folding_init_comments");
        this.fInitCollapseHeaderComments = store.getBoolean("editor_folding_init_header_comments");
        this.fInitCollapseDocs = store.getBoolean("editor_folding_init_docs");
        this.fInitCollapseClasses = store.getBoolean(this.getInitiallyFoldClassesKey());
        this.fInitCollapseMethods = store.getBoolean(this.getInitiallyFoldMethodsKey());
    }

    protected String getInitiallyFoldClassesKey() {
        return "editor_folding_init_classes";
    }

    protected String getInitiallyFoldMethodsKey() {
        return "editor_folding_init_methods";
    }

    protected boolean isEmptyRegion(IDocument d, ITypedRegion r) throws BadLocationException {
        return this.isEmptyRegion(d, r.getOffset(), r.getLength());
    }

    protected boolean isBlankRegion(IDocument document, ITypedRegion region) throws BadLocationException {
        String value = document.get(region.getOffset(), region.getLength());
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (ch != ' ' && ch != '\t') {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isEmptyRegion(IDocument d, int offset, int length) throws BadLocationException {
        return d.get(offset, length).trim().length() == 0;
    }

    protected boolean isMultilineRegion(IDocument d, IRegion region) throws BadLocationException {
        int line1 = d.getLineOfOffset(region.getOffset());
        int line2 = d.getLineOfOffset(region.getOffset() + region.getLength());
        int foldMinLines = this.getMinimalFoldableLinesCount();
        if (foldMinLines > 0) {
            return line2 - line1 + 1 >= foldMinLines;
        }
        return line1 != line2;
    }

    protected final Position createCommentPosition(IRegion aligned) {
        return new CommentPosition(aligned.getOffset(), aligned.getLength());
    }

    protected final Position createMemberPosition(IRegion aligned) {
        return new ScriptElementPosition(aligned.getOffset(), aligned.getLength());
    }

    protected IRegion alignRegion(IRegion region, FoldingStructureComputationContext ctx) {
        int end;
        int start;
        IDocument document;
        block4: {
            if (region == null) {
                return null;
            }
            document = ctx.getDocument();
            try {
                start = document.getLineOfOffset(region.getOffset());
                end = document.getLineOfOffset(region.getOffset() + region.getLength());
                if (start < end) break block4;
                return null;
            }
            catch (BadLocationException x) {
                return null;
            }
        }
        int offset = document.getLineOffset(start);
        int endOffset = document.getNumberOfLines() > end + 1 ? document.getLineOffset(end + 1) : document.getLineOffset(end) + document.getLineLength(end);
        return new Region(offset, endOffset - offset);
    }

    private ProjectionAnnotationModel getModel() {
        return (ProjectionAnnotationModel)this.fEditor.getAdapter(ProjectionAnnotationModel.class);
    }

    private IDocument getDocument() {
        IDocumentProvider provider = this.fEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fEditor.getEditorInput());
    }

    private Map<SourceRangeStamp, List<Tuple>> computeCurrentStructure(FoldingStructureComputationContext ctx) {
        HashMap<SourceRangeStamp, List<Tuple>> map = new HashMap<SourceRangeStamp, List<Tuple>>();
        ProjectionAnnotationModel model = ctx.getModel();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Annotation annotation = (Annotation)e.next();
            if (!(annotation instanceof ScriptProjectionAnnotation)) continue;
            ScriptProjectionAnnotation ann = (ScriptProjectionAnnotation)annotation;
            Position position = model.getPosition((Annotation)ann);
            ArrayList<Tuple> list = (ArrayList<Tuple>)map.get(ann.getStamp());
            if (list == null) {
                list = new ArrayList<Tuple>(2);
                map.put(ann.getStamp(), list);
            }
            list.add(new Tuple(ann, position));
        }
        Comparator comparator = (o1, o2) -> o1.position.getOffset() - o2.position.getOffset();
        for (List list : map.values()) {
            Collections.sort(list, comparator);
        }
        return map;
    }

    @Override
    public final void collapseMembers() {
        this.modifyFiltered(this.fMemberFilter, false);
    }

    @Override
    public final void collapseComments() {
        this.modifyFiltered(this.fCommentFilter, false);
    }

    private void modifyFiltered(Filter filter, boolean expand) {
        if (!this.isInstalled()) {
            return;
        }
        ProjectionAnnotationModel model = this.getModel();
        if (model == null) {
            return;
        }
        ArrayList<ScriptProjectionAnnotation> modified = new ArrayList<ScriptProjectionAnnotation>();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            ScriptProjectionAnnotation annot;
            Annotation annotation = (Annotation)iter.next();
            if (!(annotation instanceof ScriptProjectionAnnotation) || expand != (annot = (ScriptProjectionAnnotation)annotation).isCollapsed() || !filter.match(annot)) continue;
            if (expand) {
                annot.markExpanded();
            } else {
                annot.markCollapsed();
            }
            modified.add(annot);
        }
        model.modifyAnnotations(null, null, modified.toArray(new Annotation[modified.size()]));
    }

    protected abstract String getPartition();

    protected abstract String getCommentPartition();

    protected String getDocPartition() {
        return null;
    }

    protected abstract IPartitionTokenScanner getPartitionScanner();

    protected abstract String getNatureId();

    protected abstract String[] getPartitionTypes();

    protected abstract ILog getLog();

    protected FoldingASTVisitor getFoldingVisitor(int offset) {
        return new FoldingASTVisitor(offset);
    }

    protected final ISourceParser getSourceParser() {
        IProject project = this.fInput != null ? this.fInput.getScriptProject().getProject() : null;
        return DLTKLanguageManager.getSourceParser((IProject)project, (String)this.getNatureId());
    }

    protected CodeBlock[] getCodeBlocks(String code) {
        return this.getCodeBlocks(code, 0);
    }

    protected CodeBlock[] getCodeBlocks(String code, int offset) {
        ModuleDeclaration decl = this.parse(code, offset);
        if (decl == null) {
            return null;
        }
        return this.buildCodeBlocks(decl, offset);
    }

    protected final IModelElement getModuleElement() {
        return this.fInput;
    }

    protected final ModuleDeclaration parse(String code, int offset) {
        if (offset == 0 && this.fInput instanceof ISourceModule) {
            ISourceModule module = (ISourceModule)this.fInput;
            try {
                if (code.equals(module.getSource())) {
                    return SourceParserUtil.getModuleDeclaration((ISourceModule)module);
                }
            }
            catch (ModelException e) {
                this.getLog().log((IStatus)new Status(2, "org.eclipse.dltk.ui", e.getMessage(), (Throwable)e));
            }
        }
        return (ModuleDeclaration)this.getSourceParser().parse((IModuleSource)new ModuleSource(code), null);
    }

    protected CodeBlock[] buildCodeBlocks(ModuleDeclaration decl, int offset) {
        FoldingASTVisitor visitor;
        block2: {
            visitor = this.getFoldingVisitor(offset);
            try {
                decl.traverse((ASTVisitor)visitor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return visitor.getResults();
    }

    protected boolean mayCollapse(ASTNode s, FoldingStructureComputationContext ctx) {
        if (s instanceof TypeDeclaration) {
            return true;
        }
        return s instanceof MethodDeclaration;
    }

    protected boolean initiallyCollapse(ASTNode s, FoldingStructureComputationContext ctx) {
        if (ctx.allowCollapsing()) {
            return this.initiallyCollapse(s);
        }
        return false;
    }

    protected boolean initiallyCollapse(ASTNode s) {
        if (s instanceof TypeDeclaration && this.fInitCollapseClasses) {
            return true;
        }
        return s instanceof MethodDeclaration && this.fInitCollapseMethods;
    }

    protected boolean initiallyCollapseComments(IRegion commentRegion, FoldingStructureComputationContext ctx) {
        if (ctx.allowCollapsing()) {
            return this.isHeaderRegion(commentRegion, ctx) ? this.fInitCollapseHeaderComments : this.fInitCollapseComments;
        }
        return false;
    }

    protected boolean initiallyCollapseDocs(IRegion commentRegion, FoldingStructureComputationContext ctx) {
        if (ctx.allowCollapsing()) {
            return this.fInitCollapseDocs;
        }
        return false;
    }

    protected boolean isHeaderRegion(IRegion region, FoldingStructureComputationContext ctx) {
        int offset = region.getOffset();
        if (offset == 0) {
            return true;
        }
        if (offset < 100) {
            try {
                return this.isEmptyRegion(ctx.getDocument(), 0, offset);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return false;
    }

    private void installDocumentStuff(Document document) {
        IDocumentPartitioner partitioner = this.getDocumentPartitioner();
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner(this.getPartition(), partitioner);
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return new FastPartitioner(this.getPartitionScanner(), this.getPartitionTypes());
    }

    private void removeDocumentStuff(Document document) {
        document.setDocumentPartitioner(this.getPartition(), null);
    }

    @Override
    public void expandElements(IModelElement[] array) {
        this.modifyFiltered(annotation -> {
            IModelElement element = annotation.getElement();
            if (element == null) {
                return false;
            }
            int a = 0;
            while (a < array.length) {
                IModelElement e = array[a];
                if (e.equals(element)) {
                    return true;
                }
                ++a;
            }
            return false;
        }, true);
    }

    @Override
    public void collapseElements(IModelElement[] modelElements) {
    }

    private ITypedRegion getRegion(IDocument d, int offset) throws BadLocationException {
        return TextUtilities.getPartition((IDocument)d, (String)this.getPartition(), (int)offset, (boolean)true);
    }

    protected IRegion[] computeCommentsRanges(String contents) {
        return this.computeCommentsRanges(contents, this.getCommentPartition());
    }

    /*
     * Unable to fully structure code
     */
    protected IRegion[] computeCommentsRanges(String contents, String partition) {
        try {
            if (contents == null) {
                return new IRegion[0];
            }
            d = new Document(contents);
            this.installDocumentStuff(d);
            docRegionList = new ArrayList<ITypedRegion>();
            offset = 0;
            try {
                while (true) {
                    region = this.getRegion((IDocument)d, offset);
                    docRegionList.add(region);
                    offset = region.getLength() + region.getOffset() + 1;
                }
            }
            catch (BadLocationException region) {
                start = null;
                lastRegion = null;
                regions = new ArrayList<IRegion>();
                ** for (region : docRegionList)
            }
lbl-1000:
            // 1 sources

            {
                if (region.getType().equals(partition) && this.startsAtLineBegin(d, region)) {
                    if (start == null) {
                        start = region;
                    }
                } else if (!(start != null && (this.isBlankRegion((IDocument)d, region) || this.isEmptyRegion((IDocument)d, region) && this.collapseEmptyLines()))) {
                    if (start != null) {
                        offset0 = start.getOffset();
                        length0 = lastRegion.getOffset() + lastRegion.getLength() - offset0 - 1;
                        fullRegion = new Region(offset0, length0 = contents.substring(offset0, offset0 + length0).trim().length());
                        if (this.isMultilineRegion((IDocument)d, (IRegion)fullRegion)) {
                            regions.add((IRegion)fullRegion);
                        }
                    }
                    start = null;
                }
                lastRegion = region;
                continue;
            }
lbl35:
            // 1 sources

            if (start != null && this.isMultilineRegion((IDocument)d, (IRegion)(fullRegion = new Region(offset0 = start.getOffset(), length0 = lastRegion.getOffset() - offset0 + lastRegion.getLength() - 1)))) {
                regions.add((IRegion)fullRegion);
            }
            this.prepareRegions(d, regions);
            this.removeDocumentStuff(d);
            return regions.toArray(new IRegion[regions.size()]);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return new IRegion[0];
        }
    }

    protected void prepareRegions(Document d, List<IRegion> regions) {
    }

    private boolean startsAtLineBegin(Document d, ITypedRegion region) throws BadLocationException {
        int lineStart = d.getLineOffset(d.getLineOfOffset(region.getOffset()));
        return lineStart == region.getOffset() || this.isEmptyRegion((IDocument)d, lineStart, region.getOffset() - lineStart);
    }

    protected boolean collapseEmptyLines() {
        return this.fFoldNewLines;
    }

    @Deprecated
    protected final void getElementCommentResolver() {
    }

    protected static class CodeBlock {
        public ASTNode statement;
        public IRegion region;

        public CodeBlock(ASTNode s, IRegion r) {
            this.statement = s;
            this.region = r;
        }
    }

    private static final class CommentFilter
    implements Filter {
        private CommentFilter() {
        }

        @Override
        public boolean match(ScriptProjectionAnnotation annotation) {
            return annotation.isComment() && !annotation.isMarkedDeleted();
        }
    }

    private static final class CommentPosition
    extends Position
    implements IProjectionPosition {
        CommentPosition(int offset, int length) {
            super(offset, length);
        }

        public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
            Region preRegion;
            DocumentCharacterIterator sequence = new DocumentCharacterIterator(document, this.offset, this.offset + this.length);
            int prefixEnd = 0;
            int contentStart = this.findFirstContent(sequence, prefixEnd);
            int firstLine = document.getLineOfOffset(this.offset + prefixEnd);
            int captionLine = document.getLineOfOffset(this.offset + contentStart);
            int lastLine = document.getLineOfOffset(this.offset + this.length);
            if (firstLine < captionLine) {
                int preOffset = document.getLineOffset(firstLine);
                IRegion preEndLineInfo = document.getLineInformation(captionLine);
                int preEnd = preEndLineInfo.getOffset();
                preRegion = new Region(preOffset, preEnd - preOffset);
            } else {
                preRegion = null;
            }
            if (captionLine < lastLine) {
                int postOffset = document.getLineOffset(captionLine + 1);
                Region postRegion = new Region(postOffset, this.offset + this.length - postOffset);
                if (preRegion == null) {
                    return new IRegion[]{postRegion};
                }
                return new IRegion[]{preRegion, postRegion};
            }
            if (preRegion != null) {
                return new IRegion[]{preRegion};
            }
            return null;
        }

        private int findFirstContent(CharSequence content, int prefixEnd) {
            int lenght = content.length();
            int i = prefixEnd;
            while (i < lenght) {
                if (Character.isUnicodeIdentifierPart(content.charAt(i))) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        public int computeCaptionOffset(IDocument document) {
            DocumentCharacterIterator sequence = new DocumentCharacterIterator(document, this.offset, this.offset + this.length);
            return this.findFirstContent(sequence, 0);
        }
    }

    private class ElementChangedListener
    implements IElementChangedListener {
        private ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent e) {
            IModelElementDelta delta = this.findElement(AbstractASTFoldingStructureProvider.this.fInput, e.getDelta());
            if (delta != null && (delta.getFlags() & 9) != 0) {
                AbstractASTFoldingStructureProvider.this.update(AbstractASTFoldingStructureProvider.this.createContext(false));
            }
        }

        private IModelElementDelta findElement(IModelElement target, IModelElementDelta delta) {
            if (delta == null || target == null) {
                return null;
            }
            IModelElement element = delta.getElement();
            if (element.getElementType() > 5) {
                return null;
            }
            if (target.equals(element)) {
                return delta;
            }
            IModelElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                IModelElementDelta d = this.findElement(target, children[i]);
                if (d != null) {
                    return d;
                }
                ++i;
            }
            return null;
        }
    }

    private static interface Filter {
        public boolean match(ScriptProjectionAnnotation var1);
    }

    protected static class FoldingASTVisitor
    extends ASTVisitor {
        private final List<CodeBlock> result = new ArrayList<CodeBlock>();
        private final int offset;

        protected FoldingASTVisitor(int offset) {
            this.offset = offset;
        }

        public boolean visit(MethodDeclaration s) throws Exception {
            this.add((ASTNode)s);
            return super.visit(s);
        }

        public boolean visit(TypeDeclaration s) throws Exception {
            this.add((ASTNode)s);
            return super.visit(s);
        }

        public CodeBlock[] getResults() {
            return this.result.toArray(new CodeBlock[this.result.size()]);
        }

        protected final void add(ASTNode s) {
            int start = this.offset + s.sourceStart();
            int end = s.sourceEnd() - s.sourceStart();
            this.result.add(new CodeBlock(s, (IRegion)new Region(start, end)));
        }

        protected void add(CodeBlock block) {
            this.result.add(block);
        }
    }

    public static final class FoldingStructureComputationContext {
        private final ProjectionAnnotationModel fModel;
        private final IDocument fDocument;
        private final boolean fAllowCollapsing;
        protected LinkedHashMap<Annotation, Position> fMap = new LinkedHashMap();

        public FoldingStructureComputationContext(IDocument document, ProjectionAnnotationModel model, boolean allowCollapsing) {
            this.fDocument = document;
            this.fModel = model;
            this.fAllowCollapsing = allowCollapsing;
        }

        public Map<Annotation, Position> getMap() {
            return this.fMap;
        }

        public boolean allowCollapsing() {
            return this.fAllowCollapsing;
        }

        IDocument getDocument() {
            return this.fDocument;
        }

        ProjectionAnnotationModel getModel() {
            return this.fModel;
        }

        public void addProjectionRange(ScriptProjectionAnnotation annotation, Position position) {
            this.fMap.put((Annotation)annotation, position);
        }
    }

    private static final class MemberFilter
    implements Filter {
        private MemberFilter() {
        }

        @Override
        public boolean match(ScriptProjectionAnnotation annotation) {
            return !annotation.isMarkedDeleted() && annotation.getElement() instanceof IMember;
        }
    }

    public static class MethodCollector
    implements IModelElementVisitor {
        private final Map<SourceRange, IModelElement> methodByNameRange = new HashMap<SourceRange, IModelElement>();

        public boolean visit(IModelElement element) {
            if (element instanceof SourceMethod) {
                try {
                    ISourceRange nameRange = ((SourceMethod)element).getNameRange();
                    this.methodByNameRange.put(new SourceRange(nameRange), element);
                }
                catch (ModelException modelException) {
                    // empty catch block
                }
            }
            return true;
        }

        public IModelElement get(int offset, int length) {
            return this.methodByNameRange.get(new SourceRange(offset, length));
        }
    }

    private final class ProjectionListener
    implements IProjectionListener {
        private ProjectionViewer fViewer;

        public ProjectionListener(ProjectionViewer viewer) {
            this.fViewer = viewer;
            this.fViewer.addProjectionListener((IProjectionListener)this);
        }

        public void dispose() {
            if (this.fViewer != null) {
                this.fViewer.removeProjectionListener((IProjectionListener)this);
                this.fViewer = null;
            }
        }

        public void projectionEnabled() {
            AbstractASTFoldingStructureProvider.this.handleProjectionEnabled();
        }

        public void projectionDisabled() {
            AbstractASTFoldingStructureProvider.this.handleProjectionDisabled();
        }
    }

    private static final class ScriptElementPosition
    extends Position
    implements IProjectionPosition {
        public ScriptElementPosition(int offset, int length) {
            super(offset, length);
        }

        public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
            Region preRegion;
            int nameStart = this.offset;
            int firstLine = document.getLineOfOffset(this.offset);
            int captionLine = document.getLineOfOffset(nameStart);
            int lastLine = document.getLineOfOffset(this.offset + this.length);
            if (captionLine < firstLine) {
                captionLine = firstLine;
            }
            if (captionLine > lastLine) {
                captionLine = lastLine;
            }
            if (firstLine < captionLine) {
                int preOffset = document.getLineOffset(firstLine);
                IRegion preEndLineInfo = document.getLineInformation(captionLine);
                int preEnd = preEndLineInfo.getOffset();
                preRegion = new Region(preOffset, preEnd - preOffset);
            } else {
                preRegion = null;
            }
            if (captionLine < lastLine) {
                int postOffset = document.getLineOffset(captionLine + 1);
                Region postRegion = new Region(postOffset, this.offset + this.length - postOffset);
                if (preRegion == null) {
                    return new IRegion[]{postRegion};
                }
                return new IRegion[]{preRegion, postRegion};
            }
            if (preRegion != null) {
                return new IRegion[]{preRegion};
            }
            return null;
        }

        public int computeCaptionOffset(IDocument document) {
            return 0;
        }
    }

    protected static final class ScriptProjectionAnnotation
    extends ProjectionAnnotation {
        private boolean fIsComment;
        private SourceRangeStamp stamp;
        private IModelElement element;

        public ScriptProjectionAnnotation(boolean isCollapsed, boolean isComment, SourceRangeStamp codeStamp, IModelElement element) {
            super(isCollapsed);
            this.fIsComment = isComment;
            this.stamp = codeStamp;
            this.element = element;
        }

        public IModelElement getElement() {
            return this.element;
        }

        boolean isComment() {
            return this.fIsComment;
        }

        SourceRangeStamp getStamp() {
            return this.stamp;
        }

        void setStamp(SourceRangeStamp stamp) {
            this.stamp = stamp;
        }

        void setIsComment(boolean isComment) {
            this.fIsComment = isComment;
        }

        public String toString() {
            return "ScriptProjectionAnnotation:\n\tcollapsed: \t" + this.isCollapsed() + "\n\tcomment: \t" + this.isComment() + "\n";
        }
    }

    protected static final class SourceRangeStamp {
        private int hash;
        private int length;

        public SourceRangeStamp(int hash, int lenght) {
            this.hash = hash;
            this.length = lenght;
        }

        public int getHash() {
            return this.hash;
        }

        public void setHash(int hash) {
            this.hash = hash;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SourceRangeStamp) {
                SourceRangeStamp s = (SourceRangeStamp)obj;
                return s.hash == this.hash;
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static final class Tuple {
        ScriptProjectionAnnotation annotation;
        Position position;

        Tuple(ScriptProjectionAnnotation annotation, Position position) {
            this.annotation = annotation;
            this.position = position;
        }
    }
}

