/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;

public class AssignmentToItselfChecker
extends AbstractIndexAstChecker {
    private static final String ER_ID = "org.eclipse.cdt.codan.internal.checkers.AssignmentToItselfProblem";

    public void processAst(IASTTranslationUnit ast) {
        ast.accept(new ASTVisitor(){
            {
                this.shouldVisitExpressions = true;
            }

            public int visit(IASTExpression expression) {
                if (this.isAssignmentToItself(expression)) {
                    AssignmentToItselfChecker.this.reportProblem(AssignmentToItselfChecker.ER_ID, (IASTNode)expression, new Object[]{expression.getRawSignature()});
                }
                return 3;
            }

            private boolean isAssignmentToItself(IASTExpression expr) {
                IASTBinaryExpression binExpr;
                if (expr instanceof IASTBinaryExpression && (binExpr = (IASTBinaryExpression)expr).getOperator() == 17) {
                    IASTExpression operand1 = binExpr.getOperand1();
                    IASTExpression operand2 = binExpr.getOperand2();
                    if (operand1 != null && operand2 != null) {
                        String op1 = operand1.getRawSignature();
                        String op2 = operand2.getRawSignature();
                        String exprImage = binExpr.getRawSignature();
                        return op1.equals(op2) && !op1.equals(exprImage);
                    }
                }
                return false;
            }
        });
    }
}

