/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.views;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.profile.core.data.ProfilerFunctionData;
import org.eclipse.php.profile.ui.ProfilerUiPlugin;
import org.eclipse.php.profile.ui.views.AbstractTableSorter;
import org.eclipse.php.profile.ui.views.TreeElement;

public class ExecutionStatisticsSorter
extends AbstractTableSorter {
    @Override
    public int compare(Viewer viewer, Object e1, Object e2) {
        TreeElement i1 = (TreeElement)e1;
        TreeElement i2 = (TreeElement)e2;
        Object d1 = i1.getData();
        Object d2 = i2.getData();
        boolean showAsPercentage = ProfilerUiPlugin.getDefault().getPreferenceStore().getBoolean("executionViewShowAsPercentage");
        if (d1 instanceof ProfilerFunctionData && d2 instanceof ProfilerFunctionData) {
            ProfilerFunctionData f1 = (ProfilerFunctionData)d1;
            ProfilerFunctionData f2 = (ProfilerFunctionData)d2;
            switch (this.getColumn()) {
                case 1: {
                    return this.compare(f1.getCallsCount(), f2.getCallsCount());
                }
                case 2: {
                    double averageOwnTime1 = f1.getOwnTime();
                    double averageOwnTime2 = f2.getOwnTime();
                    if (f1.getCallsCount() > 0) {
                        averageOwnTime1 = f1.getOwnTime() / (double)f1.getCallsCount() / f1.getTotalTime();
                    }
                    if (f2.getCallsCount() > 0) {
                        averageOwnTime2 = f2.getOwnTime() / (double)f2.getCallsCount() / f2.getTotalTime();
                    }
                    return this.compare(averageOwnTime1, averageOwnTime2);
                }
                case 3: {
                    double ownTime1 = f1.getOwnTime();
                    double ownTime2 = f2.getOwnTime();
                    if (showAsPercentage) {
                        if (ownTime1 > 0.0) {
                            ownTime1 /= f1.getTotalTime();
                        }
                        if (ownTime2 > 0.0) {
                            ownTime2 /= f2.getTotalTime();
                        }
                    }
                    return this.compare(ownTime1, ownTime2);
                }
                case 4: {
                    double othersTime1 = f1.getTotalTime() - f1.getOwnTime();
                    double othersTime2 = f2.getTotalTime() - f2.getOwnTime();
                    if (showAsPercentage) {
                        if (othersTime1 > 0.0) {
                            othersTime1 /= f1.getTotalTime();
                        }
                        if (othersTime2 > 0.0) {
                            othersTime2 /= f2.getTotalTime();
                        }
                    }
                    return this.compare(othersTime1, othersTime2);
                }
                case 5: {
                    return this.compare(f1.getTotalTime(), f2.getTotalTime());
                }
            }
        }
        return super.compare(viewer, d1, d2);
    }
}

