/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.IVariableBinding;
import org.eclipse.php.core.ast.nodes.StaticDispatch;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.ast.visitor.Visitor;

public class StaticFieldAccess
extends StaticDispatch {
    private Variable field;
    public static final ChildPropertyDescriptor CLASS_NAME_PROPERTY = new ChildPropertyDescriptor(StaticFieldAccess.class, "className", Expression.class, true, false);
    public static final ChildPropertyDescriptor FIELD_PROPERTY = new ChildPropertyDescriptor(StaticFieldAccess.class, "field", Variable.class, true, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildPropertyDescriptor> properyList = new ArrayList<ChildPropertyDescriptor>(3);
        properyList.add(FIELD_PROPERTY);
        properyList.add(CLASS_NAME_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    @Override
    ChildPropertyDescriptor getClassNameProperty() {
        return CLASS_NAME_PROPERTY;
    }

    public StaticFieldAccess(int start, int end, AST ast, Expression className, Variable field) {
        super(start, end, ast, className);
        if (field == null) {
            throw new IllegalArgumentException();
        }
        this.setField(field);
    }

    public StaticFieldAccess(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.getClassName().accept(visitor);
        this.field.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.getClassName().traverseTopDown(visitor);
        this.field.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.getClassName().traverseBottomUp(visitor);
        this.field.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuilder buffer, String tab) {
        buffer.append(tab).append("<StaticFieldAccess");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<ClassName>\n");
        this.getClassName().toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</ClassName>\n");
        this.field.toString(buffer, "\t" + tab);
        buffer.append("\n").append(tab).append("</StaticFieldAccess>");
    }

    @Override
    public int getType() {
        return 52;
    }

    public Variable getField() {
        return this.field;
    }

    public void setField(Variable variable) {
        if (variable == null) {
            throw new IllegalArgumentException();
        }
        Variable oldChild = this.field;
        this.preReplaceChild(oldChild, variable, FIELD_PROPERTY);
        this.field = variable;
        this.postReplaceChild(oldChild, variable, FIELD_PROPERTY);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == FIELD_PROPERTY) {
            if (get) {
                return this.getField();
            }
            this.setField((Variable)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    public ASTNode getMember() {
        return this.getField();
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Expression name = ASTNode.copySubtree(target, this.getClassName());
        Variable field = ASTNode.copySubtree(target, this.getField());
        StaticFieldAccess result = new StaticFieldAccess(this.getStart(), this.getEnd(), target, name, field);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    public IVariableBinding resolveFieldBinding() {
        return this.ast.getBindingResolver().resolveField(this);
    }
}

